/*
 * Decompiled with CFR 0.152.
 */
package no.unit.nva.model.contexttypes;

import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.net.URI;
import java.net.URL;
import java.util.Objects;
import no.unit.nva.model.Level;
import no.unit.nva.model.contexttypes.BasicContext;
import no.unit.nva.model.contexttypes.LinkedContext;
import no.unit.nva.model.contexttypes.SerialPublication;
import no.unit.nva.model.contexttypes.utils.IssnUtil;
import no.unit.nva.model.exceptions.InvalidIssnException;
import nva.commons.core.JacocoGenerated;

@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, property="type")
public class Journal
implements BasicContext,
SerialPublication,
LinkedContext {
    private String title;
    private Level level;
    private boolean openAccess;
    private boolean peerReviewed;
    private String printIssn;
    private String onlineIssn;
    private URL url;
    private URI linkedContext;

    public Journal() {
    }

    private Journal(Builder builder) throws InvalidIssnException {
        this.setTitle(builder.title);
        this.setLevel(builder.level);
        this.setOpenAccess(builder.openAccess);
        this.setPeerReviewed(builder.peerReviewed);
        this.setPrintIssn(builder.printIssn);
        this.setOnlineIssn(builder.onlineIssn);
        this.setUrl(builder.url);
        this.setLinkedContextURI(builder.linkedContext);
    }

    public String getPrintIssn() {
        return this.printIssn;
    }

    @Override
    @JsonSetter
    public void setPrintIssn(String printIssn) throws InvalidIssnException {
        this.printIssn = IssnUtil.checkIssn(printIssn);
    }

    public String getOnlineIssn() {
        return this.onlineIssn;
    }

    @Override
    @JsonSetter
    public void setOnlineIssn(String onlineIssn) throws InvalidIssnException {
        this.onlineIssn = IssnUtil.checkIssn(onlineIssn);
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    @Override
    public Level getLevel() {
        return this.level;
    }

    @Override
    public void setLevel(Level level) {
        this.level = level;
    }

    @Override
    public boolean isOpenAccess() {
        return this.openAccess;
    }

    @Override
    public void setOpenAccess(boolean openAccess) {
        this.openAccess = openAccess;
    }

    @Override
    public boolean isPeerReviewed() {
        return this.peerReviewed;
    }

    @Override
    public void setPeerReviewed(boolean peerReviewed) {
        this.peerReviewed = peerReviewed;
    }

    @Override
    public URL getUrl() {
        return this.url;
    }

    @Override
    public void setUrl(URL url) {
        this.url = url;
    }

    @Override
    public URI getLinkedContext() {
        return this.linkedContext;
    }

    @Override
    public void setLinkedContext(URI linkedContext) {
        this.linkedContext = linkedContext;
    }

    private void setLinkedContextURI(URI linkedContext) {
        this.linkedContext = linkedContext;
    }

    @JacocoGenerated
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Journal)) {
            return false;
        }
        Journal journal = (Journal)o;
        return Objects.equals(this.getTitle(), journal.getTitle()) && Objects.equals(this.getPrintIssn(), journal.getPrintIssn()) && Objects.equals(this.isPeerReviewed(), journal.isPeerReviewed()) && Objects.equals(this.isOpenAccess(), journal.isOpenAccess()) && Objects.equals((Object)this.getLevel(), (Object)journal.getLevel()) && Objects.equals(this.getOnlineIssn(), journal.getOnlineIssn()) && Objects.equals(this.getUrl(), journal.getUrl()) && Objects.equals(this.getLinkedContext(), journal.getLinkedContext());
    }

    @JacocoGenerated
    public int hashCode() {
        return Objects.hash(this.getPrintIssn(), this.getOnlineIssn());
    }

    public static final class Builder {
        private String title;
        private Level level;
        private boolean openAccess;
        private boolean peerReviewed;
        private String printIssn;
        private String onlineIssn;
        private URL url;
        private URI linkedContext;

        public Builder withTitle(String title) {
            this.title = title;
            return this;
        }

        public Builder withLevel(Level level) {
            this.level = level;
            return this;
        }

        public Builder withOpenAccess(boolean openAccess) {
            this.openAccess = openAccess;
            return this;
        }

        public Builder withPeerReviewed(boolean peerReviewed) {
            this.peerReviewed = peerReviewed;
            return this;
        }

        public Builder withPrintIssn(String printIssn) {
            this.printIssn = printIssn;
            return this;
        }

        public Builder withOnlineIssn(String onlineIssn) {
            this.onlineIssn = onlineIssn;
            return this;
        }

        public Builder withUrl(URL url) {
            this.url = url;
            return this;
        }

        public Builder withLinkedContext(String linkedContext) {
            this.linkedContext = URI.create(linkedContext);
            return this;
        }

        public Journal build() throws InvalidIssnException {
            return new Journal(this);
        }
    }
}

