/*
 * Decompiled with CFR 0.152.
 */
package no.unit.nva.model.contexttypes;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import no.unit.nva.model.contexttypes.BasicContext;
import no.unit.nva.model.exceptions.InvalidIsbnException;
import no.unit.nva.model.exceptions.InvalidSeriesException;
import nva.commons.core.JacocoGenerated;
import org.apache.commons.validator.routines.ISBNValidator;

@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, property="type")
public class Book
implements BasicContext {
    public static final ISBNValidator ISBN_VALIDATOR = new ISBNValidator();
    public static final Pattern EXPECTED_SERIES_URI_PATTERN = Pattern.compile("https://.*?nva\\.aws\\.unit\\.no/publication-channels/.*");
    @Deprecated
    private String seriesTitle;
    private URI seriesUri;
    private String seriesNumber;
    private String publisher;
    private List<String> isbnList;

    @JacocoGenerated
    public int hashCode() {
        return Objects.hash(this.getSeriesTitle(), this.getSeriesUri(), this.getSeriesNumber(), this.getPublisher(), this.getIsbnList());
    }

    @JacocoGenerated
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Book)) {
            return false;
        }
        Book book = (Book)o;
        return Objects.equals(this.getSeriesTitle(), book.getSeriesTitle()) && Objects.equals(this.getSeriesUri(), book.getSeriesUri()) && Objects.equals(this.getSeriesNumber(), book.getSeriesNumber()) && Objects.equals(this.getPublisher(), book.getPublisher()) && Objects.equals(this.getIsbnList(), book.getIsbnList());
    }

    public URI getSeriesUri() {
        return this.seriesUri;
    }

    public void setSeriesUri(URI seriesUri) {
        this.validateSeriesUri(seriesUri);
        this.seriesUri = seriesUri;
    }

    private void validateSeriesUri(URI seriesUri) {
        if (!EXPECTED_SERIES_URI_PATTERN.matcher(seriesUri.toString()).matches()) {
            throw new InvalidSeriesException(seriesUri.toString());
        }
    }

    public List<String> getIsbnList() {
        return Objects.nonNull(this.isbnList) ? this.isbnList : Collections.emptyList();
    }

    public void setIsbnList(List<String> isbnList) throws InvalidIsbnException {
        if (Objects.isNull(isbnList) || isbnList.isEmpty()) {
            this.isbnList = Collections.emptyList();
            return;
        }
        List validIsbns = isbnList.stream().map(arg_0 -> ((ISBNValidator)ISBN_VALIDATOR).validate(arg_0)).filter(Objects::nonNull).collect(Collectors.toList());
        if (isbnList.size() != validIsbns.size()) {
            ArrayList<String> errors = new ArrayList<String>(isbnList);
            errors.removeAll(validIsbns);
            throw new InvalidIsbnException(errors);
        }
        this.isbnList = validIsbns;
    }

    public String getSeriesTitle() {
        return this.seriesTitle;
    }

    public void setSeriesTitle(String seriesTitle) {
        this.seriesTitle = seriesTitle;
    }

    public String getSeriesNumber() {
        return this.seriesNumber;
    }

    public void setSeriesNumber(String seriesNumber) {
        this.seriesNumber = seriesNumber;
    }

    public String getPublisher() {
        return this.publisher;
    }

    public void setPublisher(String publisher) {
        this.publisher = publisher;
    }

    public Builder copy() throws InvalidIsbnException {
        return new Builder().withSeriesNumber(this.getSeriesNumber()).withSeriesTitle(this.getSeriesTitle()).withPublisher(this.getPublisher()).withIsbnList(this.getIsbnList()).withSeriesUri(this.getSeriesUri());
    }

    public static final class Builder {
        private final Book book = new Book();

        public Builder withSeriesTitle(String seriesTitle) {
            this.book.setSeriesTitle(seriesTitle);
            return this;
        }

        public Builder withSeriesUri(URI seriesUri) {
            this.book.setSeriesUri(seriesUri);
            return this;
        }

        public Builder withSeriesNumber(String seriesNumber) {
            this.book.setSeriesNumber(seriesNumber);
            return this;
        }

        public Builder withPublisher(String publisher) {
            this.book.setPublisher(publisher);
            return this;
        }

        public Builder withIsbnList(List<String> isbnList) throws InvalidIsbnException {
            this.book.setIsbnList(isbnList);
            return this;
        }

        public Book build() {
            return this.book;
        }
    }
}

