/*
 * Decompiled with CFR 0.152.
 */
package no.unit.nva.model.contexttypes;

import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.util.Objects;
import no.unit.nva.model.contexttypes.BasicContext;
import no.unit.nva.model.contexttypes.SerialPublication;
import no.unit.nva.model.contexttypes.utils.IssnUtil;
import no.unit.nva.model.exceptions.InvalidIssnException;
import nva.commons.core.JacocoGenerated;

@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, property="type")
public class Journal
implements BasicContext,
SerialPublication {
    private String title;
    private String printIssn;
    private String onlineIssn;

    public Journal() {
    }

    private Journal(Builder builder) throws InvalidIssnException {
        this.setTitle(builder.title);
        this.setPrintIssn(builder.printIssn);
        this.setOnlineIssn(builder.onlineIssn);
    }

    public String getPrintIssn() {
        return this.printIssn;
    }

    @Override
    @JsonSetter
    public void setPrintIssn(String printIssn) throws InvalidIssnException {
        this.printIssn = IssnUtil.checkIssn(printIssn);
    }

    public String getOnlineIssn() {
        return this.onlineIssn;
    }

    @Override
    @JsonSetter
    public void setOnlineIssn(String onlineIssn) throws InvalidIssnException {
        this.onlineIssn = IssnUtil.checkIssn(onlineIssn);
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    @JacocoGenerated
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Journal)) {
            return false;
        }
        Journal journal = (Journal)o;
        return Objects.equals(this.getTitle(), journal.getTitle()) && Objects.equals(this.getPrintIssn(), journal.getPrintIssn()) && Objects.equals(this.getOnlineIssn(), journal.getOnlineIssn());
    }

    @JacocoGenerated
    public int hashCode() {
        return Objects.hash(this.getTitle(), this.getPrintIssn(), this.getOnlineIssn());
    }

    public static final class Builder {
        private String title;
        private String printIssn;
        private String onlineIssn;

        public Builder withTitle(String title) {
            this.title = title;
            return this;
        }

        public Builder withPrintIssn(String printIssn) {
            this.printIssn = printIssn;
            return this;
        }

        public Builder withOnlineIssn(String onlineIssn) {
            this.onlineIssn = onlineIssn;
            return this;
        }

        public Journal build() throws InvalidIssnException {
            return new Journal(this);
        }
    }
}

