/*
 * Decompiled with CFR 0.152.
 */
package no.unit.nva.model.contexttypes;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.util.Objects;
import no.unit.nva.model.contexttypes.Series;
import no.unit.nva.model.contexttypes.UnconfirmedSeries;
import no.unit.nva.model.exceptions.InvalidUnconfirmedSeriesException;

@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, property="type")
@JsonSubTypes(value={@JsonSubTypes.Type(name="Series", value=Series.class), @JsonSubTypes.Type(name="UnconfirmedSeries", value=UnconfirmedSeries.class)})
public interface BookSeries {
    @JsonIgnore
    public boolean isConfirmed();

    public static BookSeries extractSeriesInformation(BookSeries series, String unconfirmedSeriesTitle) throws InvalidUnconfirmedSeriesException {
        if (Objects.nonNull(series) && series.isConfirmed()) {
            return series;
        }
        BookSeries.validateUnconfirmedSeries(series, unconfirmedSeriesTitle);
        if (Objects.nonNull(unconfirmedSeriesTitle) && Objects.isNull(series)) {
            return new UnconfirmedSeries(unconfirmedSeriesTitle);
        }
        return series;
    }

    private static void validateUnconfirmedSeries(BookSeries series, String unconfirmedSeriesTitle) throws InvalidUnconfirmedSeriesException {
        if (BookSeries.hasSeriesStringAndSeriesObject(series, unconfirmedSeriesTitle) && BookSeries.hasUnmatchedSeriesStringValues(series, unconfirmedSeriesTitle)) {
            throw new InvalidUnconfirmedSeriesException();
        }
    }

    private static boolean hasUnmatchedSeriesStringValues(BookSeries series, String unconfirmedSeriesTitle) {
        return !series.isConfirmed() && !((UnconfirmedSeries)series).getTitle().equals(unconfirmedSeriesTitle);
    }

    private static boolean hasSeriesStringAndSeriesObject(BookSeries series, String unconfirmedSeriesTitle) {
        return Objects.nonNull(series) && Objects.nonNull(unconfirmedSeriesTitle);
    }
}

