/*
 * Decompiled with CFR 0.152.
 */
package no.unit.nva.model.contexttypes;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;
import java.util.Objects;
import no.unit.nva.model.contexttypes.BasicContext;
import no.unit.nva.model.contexttypes.Book;
import no.unit.nva.model.contexttypes.BookSeries;
import no.unit.nva.model.contexttypes.PublishingHouse;
import no.unit.nva.model.contexttypes.SerialPublication;
import no.unit.nva.model.contexttypes.utils.IssnUtil;
import no.unit.nva.model.exceptions.InvalidIsbnException;
import no.unit.nva.model.exceptions.InvalidIssnException;
import no.unit.nva.model.exceptions.InvalidUnconfirmedSeriesException;
import nva.commons.core.JacocoGenerated;

public class Report
extends Book
implements SerialPublication,
BasicContext {
    private final String printIssn;
    private final String onlineIssn;

    @JsonCreator
    public Report(@JsonProperty(value="series") BookSeries series, @JsonProperty(value="seriesTitle") String seriesTitle, @JsonProperty(value="seriesNumber") String seriesNumber, @JsonProperty(value="publisher") PublishingHouse publisher, @JsonProperty(value="isbnList") List<String> isbnList, @JsonProperty(value="printIssn") String printIssn, @JsonProperty(value="onlineIssn") String onlineIssn) throws InvalidIsbnException, InvalidIssnException, InvalidUnconfirmedSeriesException {
        super(series, seriesTitle, seriesNumber, publisher, isbnList);
        this.printIssn = IssnUtil.checkIssn(printIssn);
        this.onlineIssn = IssnUtil.checkIssn(onlineIssn);
    }

    private Report(Builder builder) throws InvalidIssnException, InvalidIsbnException, InvalidUnconfirmedSeriesException {
        this(builder.series, null, builder.seriesNumber, builder.publisher, builder.isbnList, builder.printIssn, builder.onlineIssn);
    }

    @Override
    public String getPrintIssn() {
        return this.printIssn;
    }

    @Override
    public String getOnlineIssn() {
        return this.onlineIssn;
    }

    @Override
    @JacocoGenerated
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Report)) {
            return false;
        }
        Report report = (Report)o;
        return Objects.equals(this.getPrintIssn(), report.getPrintIssn()) && Objects.equals(this.getOnlineIssn(), report.getOnlineIssn());
    }

    @Override
    @JacocoGenerated
    public int hashCode() {
        return Objects.hash(this.getPrintIssn(), this.getOnlineIssn());
    }

    public static final class Builder {
        private BookSeries series;
        private String seriesNumber;
        private PublishingHouse publisher;
        private List<String> isbnList;
        private String printIssn;
        private String onlineIssn;

        public Builder withSeries(BookSeries series) {
            this.series = series;
            return this;
        }

        public Builder withSeriesNumber(String seriesNumber) {
            this.seriesNumber = seriesNumber;
            return this;
        }

        public Builder withPublisher(PublishingHouse publisher) {
            this.publisher = publisher;
            return this;
        }

        public Builder withIsbnList(List<String> isbnList) {
            this.isbnList = isbnList;
            return this;
        }

        public Builder withPrintIssn(String printIssn) {
            this.printIssn = printIssn;
            return this;
        }

        public Builder withOnlineIssn(String onlineIssn) {
            this.onlineIssn = onlineIssn;
            return this;
        }

        public Report build() throws InvalidIssnException, InvalidIsbnException, InvalidUnconfirmedSeriesException {
            return new Report(this);
        }
    }
}

