/*
 * Decompiled with CFR 0.152.
 */
package no.unit.nva.model;

import com.fasterxml.jackson.annotation.JsonValue;
import java.util.Arrays;
import java.util.stream.Collectors;

public enum Role {
    ADVISOR("Advisor"),
    CREATOR("Creator"),
    EDITOR("Editor"),
    ILLUSTRATOR("Illustrator"),
    OTHER("Other"),
    CONTACT_PERSON("ContactPerson"),
    DATA_COLLECTOR("DataCollector"),
    DATA_CURATOR("DataCurator"),
    DATA_MANAGER("DataManager"),
    DISTRIBUTOR("Distributor"),
    FUNDER("Funder"),
    HOSTING_INSTITUTION("HostingInstitution"),
    PRODUCER("Producer"),
    PROJECT_LEADER("ProjectLeader"),
    PROJECT_MANAGER("ProjectManager"),
    PROJECT_MEMBER("ProjectMember"),
    REGISTRATION_AGENCY("RegistrationAgency"),
    REGISTRATION_AUTHORITY("RegistrationAuthority"),
    RELATED_PERSON("RelatedPerson"),
    RESEARCHER("Researcher"),
    RESEARCH_GROUP("ResearchGroup"),
    RIGHTS_HOLDER("RightsHolder"),
    SPONSOR("Sponsor"),
    SUPERVISOR("Supervisor"),
    WORK_PACKAGE_LEADER("WorkPackageLeader");

    public static final String ERROR_MESSAGE_TEMPLATE = "%s not a valid Role, expected one of: %s";
    public static final String DELIMITER = ", ";
    private final String value;

    private Role(String value) {
        this.value = value;
    }

    @JsonValue
    public String getValue() {
        return this.value;
    }

    public static Role lookup(String value) {
        return Arrays.stream(Role.values()).filter(nameType -> nameType.getValue().equalsIgnoreCase(value)).findAny().orElseThrow(() -> new IllegalArgumentException(String.format(ERROR_MESSAGE_TEMPLATE, value, Arrays.stream(Role.values()).map(Enum::toString).collect(Collectors.joining(DELIMITER)))));
    }
}

