/*
 * Decompiled with CFR 0.152.
 */
package no.unit.nva.model.contexttypes;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import no.unit.nva.model.contexttypes.BasicContext;
import no.unit.nva.model.contexttypes.BookSeries;
import no.unit.nva.model.contexttypes.PublishingHouse;
import no.unit.nva.model.exceptions.InvalidIsbnException;
import no.unit.nva.model.exceptions.InvalidUnconfirmedSeriesException;
import nva.commons.core.JacocoGenerated;
import org.apache.commons.validator.routines.ISBNValidator;

@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, property="type")
public class Book
implements BasicContext {
    public static final ISBNValidator ISBN_VALIDATOR = new ISBNValidator();
    public static final String JSON_PROPERTY_SERIES = "series";
    public static final String JSON_PROPERTY_SERIES_TITLE = "seriesTitle";
    public static final String JSON_PROPERTY_SERIES_NUMBER = "seriesNumber";
    public static final String JSON_PROPERTY_PUBLISHER = "publisher";
    public static final String JSON_PROPERTY_ISBN_LIST = "isbnList";
    public static final String ANYTHING_BUT_DIGITS_REGEX = "[\\D.]";
    @JsonProperty(value="series")
    private final BookSeries series;
    @JsonProperty(value="seriesNumber")
    private final String seriesNumber;
    @JsonProperty(value="publisher")
    private final PublishingHouse publisher;
    @JsonProperty(value="isbnList")
    private final List<String> isbnList;

    public Book(@JsonProperty(value="series") BookSeries series, @JsonProperty(value="seriesTitle", access=JsonProperty.Access.WRITE_ONLY) String unconfirmedSeriesTitle, @JsonProperty(value="seriesNumber") String seriesNumber, @JsonProperty(value="publisher") PublishingHouse publisher, @JsonProperty(value="isbnList") List<String> isbnList) throws InvalidIsbnException, InvalidUnconfirmedSeriesException {
        this(BookSeries.extractSeriesInformation(series, unconfirmedSeriesTitle), seriesNumber, publisher, isbnList);
    }

    public Book(BookSeries series, String seriesNumber, PublishingHouse publisher, List<String> isbnList) throws InvalidIsbnException {
        this.series = series;
        this.seriesNumber = seriesNumber;
        this.publisher = publisher;
        this.isbnList = this.extractValidIsbnList(isbnList);
    }

    public BookSeries getSeries() {
        return this.series;
    }

    public String getSeriesNumber() {
        return this.seriesNumber;
    }

    public PublishingHouse getPublisher() {
        return this.publisher;
    }

    public List<String> getIsbnList() {
        return Objects.nonNull(this.isbnList) ? this.isbnList : Collections.emptyList();
    }

    private List<String> extractValidIsbnList(List<String> isbnList) throws InvalidIsbnException {
        if (Objects.isNull(isbnList) || isbnList.isEmpty()) {
            return Collections.emptyList();
        }
        List<String> validIsbns = isbnList.stream().map(isbn -> isbn.replaceAll(ANYTHING_BUT_DIGITS_REGEX, "")).map(arg_0 -> ((ISBNValidator)ISBN_VALIDATOR).validate(arg_0)).filter(Objects::nonNull).collect(Collectors.toList());
        if (isbnList.size() != validIsbns.size()) {
            ArrayList<String> errors = new ArrayList<String>(isbnList);
            errors.removeAll(validIsbns);
            throw new InvalidIsbnException(errors);
        }
        return validIsbns;
    }

    public BookBuilder copy() throws InvalidIsbnException {
        return new BookBuilder().withSeriesNumber(this.getSeriesNumber()).withSeries(this.getSeries()).withPublisher(this.getPublisher()).withIsbnList(this.getIsbnList());
    }

    @JacocoGenerated
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Book)) {
            return false;
        }
        Book book = (Book)o;
        return Objects.equals(this.getSeries(), book.getSeries()) && Objects.equals(this.getSeriesNumber(), book.getSeriesNumber()) && Objects.equals(this.getPublisher(), book.getPublisher()) && Objects.equals(this.getIsbnList(), book.getIsbnList());
    }

    @JacocoGenerated
    public int hashCode() {
        return Objects.hash(this.getSeries(), this.getSeriesNumber(), this.getPublisher(), this.getIsbnList());
    }

    public static final class BookBuilder {
        private BookSeries series;
        private String seriesNumber;
        private PublishingHouse publisher;
        private List<String> isbnList;

        public BookBuilder withSeries(BookSeries series) {
            this.series = series;
            return this;
        }

        public BookBuilder withSeriesNumber(String seriesNumber) {
            this.seriesNumber = seriesNumber;
            return this;
        }

        public BookBuilder withPublisher(PublishingHouse publisher) {
            this.publisher = publisher;
            return this;
        }

        public BookBuilder withIsbnList(List<String> isbnList) {
            this.isbnList = isbnList;
            return this;
        }

        public Book build() throws InvalidIsbnException {
            return new Book(this.series, this.seriesNumber, this.publisher, this.isbnList);
        }
    }
}

