/*
 * Decompiled with CFR 0.152.
 */
package no.unit.nva.model.instancetypes.journal;

import com.fasterxml.jackson.annotation.JsonValue;
import java.util.Arrays;
import java.util.stream.Collectors;

public enum JournalArticleContentType {
    RESEARCH_ARTICLE("Research article"),
    REVIEW_ARTICLE("Review article"),
    CASE_REPORT("Case report"),
    STUDY_PROTOCOL("Study protocol"),
    PROFESSIONAL_ARTICLE("Professional article"),
    POPULAR_SCIENCE_ARTICLE("Popular science article");

    public static final String ERROR_MESSAGE_TEMPLATE = "%s not a valid JournalArticleContentType, expected one of: %s";
    public static final String DELIMITER = ", ";
    private final String value;

    private JournalArticleContentType(String value) {
        this.value = value;
    }

    @JsonValue
    public String getValue() {
        return this.value;
    }

    public static JournalArticleContentType lookup(String value) {
        return Arrays.stream(JournalArticleContentType.values()).filter(nameType -> nameType.getValue().equalsIgnoreCase(value)).findAny().orElseThrow(() -> new IllegalArgumentException(String.format(ERROR_MESSAGE_TEMPLATE, value, Arrays.stream(JournalArticleContentType.values()).map(Enum::toString).collect(Collectors.joining(DELIMITER)))));
    }
}

