/*
 * Decompiled with CFR 0.152.
 */
package no.unit.nva.model;

import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.net.URI;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import no.unit.nva.model.Contributor;
import no.unit.nva.model.PublicationDate;
import no.unit.nva.model.Reference;
import nva.commons.core.JacocoGenerated;

@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, property="type")
public class EntityDescription {
    private String mainTitle;
    private Map<String, String> alternativeTitles;
    private URI language;
    private PublicationDate date;
    private List<Contributor> contributors;
    @JsonSetter(value="abstract")
    private String mainLanguageAbstract;
    private String npiSubjectHeading;
    private List<String> tags;
    private String description;
    private Reference reference;
    private URI metadataSource;

    public EntityDescription() {
    }

    private EntityDescription(Builder builder) {
        this.setMainTitle(builder.mainTitle);
        this.setAlternativeTitles(builder.alternativeTitles);
        this.setLanguage(builder.language);
        this.setDate(builder.date);
        this.setContributors(builder.contributors);
        this.setAbstract(builder.mainLanguageAbstract);
        this.setNpiSubjectHeading(builder.npiSubjectHeading);
        this.setTags(builder.tags);
        this.setDescription(builder.description);
        this.setReference(builder.reference);
        this.setMetadataSource(builder.metadataSource);
    }

    public String getMainTitle() {
        return this.mainTitle;
    }

    public void setMainTitle(String mainTitle) {
        this.mainTitle = mainTitle;
    }

    public Map<String, String> getAlternativeTitles() {
        return this.alternativeTitles;
    }

    public void setAlternativeTitles(Map<String, String> alternativeTitles) {
        this.alternativeTitles = alternativeTitles;
    }

    public URI getLanguage() {
        return this.language;
    }

    public void setLanguage(URI language) {
        this.language = language;
    }

    public PublicationDate getDate() {
        return this.date;
    }

    public void setDate(PublicationDate date) {
        this.date = date;
    }

    public List<Contributor> getContributors() {
        return this.contributors;
    }

    public void setContributors(List<Contributor> contributors) {
        this.contributors = contributors;
    }

    public URI getMetadataSource() {
        return this.metadataSource;
    }

    public void setMetadataSource(URI metadataSource) {
        this.metadataSource = metadataSource;
    }

    public String getAbstract() {
        return this.mainLanguageAbstract;
    }

    public void setAbstract(String mainLanguageAbstract) {
        this.mainLanguageAbstract = mainLanguageAbstract;
    }

    public String getNpiSubjectHeading() {
        return this.npiSubjectHeading;
    }

    public void setNpiSubjectHeading(String npiSubjectHeading) {
        this.npiSubjectHeading = npiSubjectHeading;
    }

    public List<String> getTags() {
        return this.tags;
    }

    public void setTags(List<String> tags) {
        this.tags = tags;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Reference getReference() {
        return this.reference;
    }

    public void setReference(Reference reference) {
        this.reference = reference;
    }

    @JacocoGenerated
    public int hashCode() {
        return Objects.hash(this.getMainTitle(), this.getAlternativeTitles(), this.getLanguage(), this.getDate(), this.getContributors(), this.getAbstract(), this.getNpiSubjectHeading(), this.getTags(), this.getDescription(), this.getReference(), this.getMetadataSource());
    }

    @JacocoGenerated
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof EntityDescription)) {
            return false;
        }
        EntityDescription that = (EntityDescription)o;
        return Objects.equals(this.getMainTitle(), that.getMainTitle()) && Objects.equals(this.getAlternativeTitles(), that.getAlternativeTitles()) && Objects.equals(this.getLanguage(), that.getLanguage()) && Objects.equals(this.getDate(), that.getDate()) && Objects.equals(this.getContributors(), that.getContributors()) && Objects.equals(this.mainLanguageAbstract, that.mainLanguageAbstract) && Objects.equals(this.getNpiSubjectHeading(), that.getNpiSubjectHeading()) && Objects.equals(this.getTags(), that.getTags()) && Objects.equals(this.getDescription(), that.getDescription()) && Objects.equals(this.getReference(), that.getReference()) && Objects.equals(this.getMetadataSource(), that.getMetadataSource());
    }

    public static final class Builder {
        private String mainTitle;
        private Map<String, String> alternativeTitles;
        private URI language;
        private PublicationDate date;
        private List<Contributor> contributors;
        private String mainLanguageAbstract;
        private String npiSubjectHeading;
        private List<String> tags;
        private String description;
        private Reference reference;
        private URI metadataSource;

        public Builder withMainTitle(String mainTitle) {
            this.mainTitle = mainTitle;
            return this;
        }

        public Builder withAlternativeTitles(Map<String, String> alternativeTitles) {
            this.alternativeTitles = alternativeTitles;
            return this;
        }

        public Builder withLanguage(URI language) {
            this.language = language;
            return this;
        }

        public Builder withDate(PublicationDate date) {
            this.date = date;
            return this;
        }

        public Builder withContributors(List<Contributor> contributors) {
            this.contributors = contributors;
            return this;
        }

        public Builder withAbstract(String mainLanguageAbstract) {
            this.mainLanguageAbstract = mainLanguageAbstract;
            return this;
        }

        public Builder withNpiSubjectHeading(String npiSubjectHeading) {
            this.npiSubjectHeading = npiSubjectHeading;
            return this;
        }

        public Builder withTags(List<String> tags) {
            this.tags = tags;
            return this;
        }

        public Builder withDescription(String description) {
            this.description = description;
            return this;
        }

        public Builder withReference(Reference reference) {
            this.reference = reference;
            return this;
        }

        public Builder withMetadataSource(URI metadataSource) {
            this.metadataSource = metadataSource;
            return this;
        }

        public EntityDescription build() {
            return new EntityDescription(this);
        }
    }
}

