/*
 * Decompiled with CFR 0.152.
 */
package no.unit.nva.model;

import java.util.Collections;
import java.util.Set;

public enum DoiRequestStatus {
    REQUESTED,
    APPROVED,
    REJECTED;

    public static final String ERROR_MESSAGE_NOT_ALLOWED_TO_CHANGE_STATUS_FROM_S_TO_S = "Not allowed to change status from %s to %s";
    public static final String INVALID_DOI_REQUEST_STATUS_ERROR = "Invalid DoiRequest status: ";
    protected static final Set<DoiRequestStatus> validStatusChangeForRejected;
    protected static final Set<DoiRequestStatus> validStatusChangeForRequested;
    protected static final Set<DoiRequestStatus> validDefaultStatusChanges;

    public static DoiRequestStatus parse(String doiRequestStatus) {
        DoiRequestStatus[] values;
        for (DoiRequestStatus status : values = DoiRequestStatus.values()) {
            if (!status.name().equalsIgnoreCase(doiRequestStatus)) continue;
            return status;
        }
        throw new IllegalArgumentException(INVALID_DOI_REQUEST_STATUS_ERROR + doiRequestStatus);
    }

    public boolean isValidStatusChange(DoiRequestStatus requestedStatusChange) {
        return this.getValidTransitions(this).contains((Object)requestedStatusChange);
    }

    public DoiRequestStatus changeStatus(DoiRequestStatus requestedStatusChange) {
        if (this.isValidStatusChange(requestedStatusChange)) {
            return requestedStatusChange;
        }
        throw new IllegalArgumentException(this.getErrorMessageForNotAllowedStatusChange(requestedStatusChange));
    }

    protected String getErrorMessageForNotAllowedStatusChange(DoiRequestStatus requestedStatusChange) {
        return String.format(ERROR_MESSAGE_NOT_ALLOWED_TO_CHANGE_STATUS_FROM_S_TO_S, new Object[]{this, requestedStatusChange});
    }

    private Set<DoiRequestStatus> getValidTransitions(DoiRequestStatus fromRequestStatus) {
        switch (fromRequestStatus) {
            case REQUESTED: {
                return validStatusChangeForRequested;
            }
            case REJECTED: {
                return validStatusChangeForRejected;
            }
        }
        return validDefaultStatusChanges;
    }

    static {
        validStatusChangeForRejected = Set.of(APPROVED);
        validStatusChangeForRequested = Set.of(APPROVED, REJECTED);
        validDefaultStatusChanges = Collections.emptySet();
    }
}

