/*
 * Decompiled with CFR 0.152.
 */
package no.unit.nva.model.pages;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.time.LocalDateTime;
import java.time.temporal.ChronoUnit;
import java.util.Objects;
import no.unit.nva.model.contexttypes.event.ReifiedExtent;
import no.unit.nva.model.pages.Pages;
import nva.commons.core.JacocoGenerated;

@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, property="type")
public class TemporalExtent
implements Pages {
    public static final String FROM = "from";
    public static final String TO = "to";
    @JsonProperty(value="from")
    private final LocalDateTime from;
    @JsonProperty(value="to")
    private final LocalDateTime to;

    public TemporalExtent(@JsonProperty(value="from") LocalDateTime from, @JsonProperty(value="to") LocalDateTime to) {
        this.from = from;
        this.to = to;
    }

    public LocalDateTime getFrom() {
        return this.from;
    }

    public LocalDateTime getTo() {
        return this.to;
    }

    public ReifiedExtent getExtent() {
        return new ReifiedExtent(String.valueOf(ChronoUnit.HOURS.between(this.from, this.to)), ChronoUnit.HOURS.toString());
    }

    @JacocoGenerated
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof TemporalExtent)) {
            return false;
        }
        TemporalExtent that = (TemporalExtent)o;
        return Objects.equals(this.getFrom(), that.getFrom()) && Objects.equals(this.getTo(), that.getTo());
    }

    @JacocoGenerated
    public int hashCode() {
        return Objects.hash(this.getFrom(), this.getTo());
    }
}

