/*
 * Decompiled with CFR 0.152.
 */
package no.unit.nva.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.net.URI;
import java.time.Instant;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import no.unit.nva.WithFile;
import no.unit.nva.WithIdentifier;
import no.unit.nva.WithInternal;
import no.unit.nva.WithMetadata;
import no.unit.nva.identifiers.SortableIdentifier;
import no.unit.nva.model.AdditionalIdentifier;
import no.unit.nva.model.DoiRequest;
import no.unit.nva.model.DoiRequestStatus;
import no.unit.nva.model.EntityDescription;
import no.unit.nva.model.FileSet;
import no.unit.nva.model.Organization;
import no.unit.nva.model.PublicationStatus;
import no.unit.nva.model.ResearchProject;
import no.unit.nva.model.WithCopy;
import no.unit.nva.model.exceptions.InvalidPublicationStatusTransitionException;
import nva.commons.core.JacocoGenerated;

@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, property="type")
public class Publication
implements WithIdentifier,
WithInternal,
WithFile,
WithMetadata,
WithCopy<Builder> {
    public static final Map<PublicationStatus, List<PublicationStatus>> validStatusTransitionsMap = Map.of(PublicationStatus.NEW, List.of(PublicationStatus.DRAFT), PublicationStatus.DRAFT, List.of(PublicationStatus.PUBLISHED, PublicationStatus.DRAFT_FOR_DELETION));
    public static final String ERROR_MESSAGE_UPDATEDOIREQUEST_MISSING_DOIREQUEST = "You must initiate creation of a DoiRequest before you can update it.";
    private static final String MODEL_VERSION = "0.14.8";
    private SortableIdentifier identifier;
    private PublicationStatus status;
    private String owner;
    private Organization publisher;
    private Instant createdDate;
    private Instant modifiedDate;
    private Instant publishedDate;
    private Instant indexedDate;
    private URI handle;
    private URI doi;
    private DoiRequest doiRequest;
    private URI link;
    private EntityDescription entityDescription;
    private FileSet fileSet;
    private List<ResearchProject> projects;
    private Set<AdditionalIdentifier> additionalIdentifiers;
    private List<URI> subjects;

    public Publication() {
    }

    private Publication(Builder builder) {
        this.setIdentifier(builder.identifier);
        this.setStatus(builder.status);
        this.setOwner(builder.owner);
        this.setPublisher(builder.publisher);
        this.setCreatedDate(builder.createdDate);
        this.setModifiedDate(builder.modifiedDate);
        this.setPublishedDate(builder.publishedDate);
        this.setIndexedDate(builder.indexedDate);
        this.setHandle(builder.handle);
        this.setDoi(builder.doi);
        this.setDoiRequest(builder.doiRequest);
        this.setLink(builder.link);
        this.setEntityDescription(builder.entityDescription);
        this.setFileSet(builder.fileSet);
        this.setProjects(builder.projects);
        this.setAdditionalIdentifiers(builder.additionalIdentifiers);
        this.setSubjects(builder.subjects);
    }

    public Set<AdditionalIdentifier> getAdditionalIdentifiers() {
        return Objects.nonNull(this.additionalIdentifiers) ? this.additionalIdentifiers : Collections.emptySet();
    }

    public void setAdditionalIdentifiers(Set<AdditionalIdentifier> additionalIdentifiers) {
        this.additionalIdentifiers = additionalIdentifiers;
    }

    @Override
    public Instant getCreatedDate() {
        return this.createdDate;
    }

    @Override
    public void setCreatedDate(Instant createdDate) {
        this.createdDate = createdDate;
    }

    @Override
    public PublicationStatus getStatus() {
        return this.status;
    }

    @Override
    public void setStatus(PublicationStatus status) {
        this.status = status;
    }

    @Override
    public URI getHandle() {
        return this.handle;
    }

    @Override
    public void setHandle(URI handle) {
        this.handle = handle;
    }

    @Override
    public Instant getPublishedDate() {
        return this.publishedDate;
    }

    @Override
    public void setPublishedDate(Instant publishedDate) {
        this.publishedDate = publishedDate;
    }

    @Override
    public Instant getModifiedDate() {
        return this.modifiedDate;
    }

    @Override
    public void setModifiedDate(Instant modifiedDate) {
        this.modifiedDate = modifiedDate;
    }

    @Override
    public String getOwner() {
        return this.owner;
    }

    @Override
    public void setOwner(String owner) {
        this.owner = owner;
    }

    @Override
    public Instant getIndexedDate() {
        return this.indexedDate;
    }

    @Override
    public void setIndexedDate(Instant indexedDate) {
        this.indexedDate = indexedDate;
    }

    @Override
    public URI getLink() {
        return this.link;
    }

    @Override
    public void setLink(URI link) {
        this.link = link;
    }

    @Override
    public Organization getPublisher() {
        return this.publisher;
    }

    @Override
    public void setPublisher(Organization publisher) {
        this.publisher = publisher;
    }

    @Override
    public URI getDoi() {
        return this.doi;
    }

    @Override
    public void setDoi(URI doi) {
        this.doi = doi;
    }

    @Override
    public DoiRequest getDoiRequest() {
        return this.doiRequest;
    }

    @Override
    public void setDoiRequest(DoiRequest doiRequest) {
        this.doiRequest = doiRequest;
    }

    public void updateDoiRequestStatus(DoiRequestStatus requestedStatusChange) {
        if (Objects.isNull(this.doiRequest)) {
            throw new IllegalStateException(ERROR_MESSAGE_UPDATEDOIREQUEST_MISSING_DOIREQUEST);
        }
        Instant now = Instant.now();
        DoiRequest updatedDoiRequest = this.getDoiRequest().copy().withStatus(this.getDoiRequest().getStatus().changeStatus(requestedStatusChange)).withModifiedDate(now).build();
        this.setDoiRequest(updatedDoiRequest);
        this.setModifiedDate(now);
    }

    @Override
    public SortableIdentifier getIdentifier() {
        return this.identifier;
    }

    @Override
    public void setIdentifier(SortableIdentifier identifier) {
        this.identifier = identifier;
    }

    @Override
    public EntityDescription getEntityDescription() {
        return this.entityDescription;
    }

    @Override
    public void setEntityDescription(EntityDescription entityDescription) {
        this.entityDescription = entityDescription;
    }

    @Override
    public List<ResearchProject> getProjects() {
        return Objects.nonNull(this.projects) ? this.projects : Collections.emptyList();
    }

    @Override
    public void setProjects(List<ResearchProject> projects) {
        this.projects = projects;
    }

    @Override
    public List<URI> getSubjects() {
        return Objects.nonNull(this.subjects) ? this.subjects : Collections.emptyList();
    }

    @Override
    public void setSubjects(List<URI> subjects) {
        this.subjects = subjects;
    }

    @Override
    public FileSet getFileSet() {
        return this.fileSet;
    }

    @Override
    public void setFileSet(FileSet fileSet) {
        this.fileSet = fileSet;
    }

    @JsonProperty(value="modelVersion")
    public String getModelVersion() {
        return MODEL_VERSION;
    }

    @JsonProperty(value="modelVersion")
    public void setModelVersion() {
    }

    @Override
    public Builder copy() {
        return new Builder().withIdentifier(this.getIdentifier()).withStatus(this.getStatus()).withOwner(this.getOwner()).withPublisher(this.getPublisher()).withCreatedDate(this.getCreatedDate()).withModifiedDate(this.getModifiedDate()).withPublishedDate(this.getPublishedDate()).withIndexedDate(this.getIndexedDate()).withHandle(this.getHandle()).withDoi(this.getDoi()).withDoiRequest(this.getDoiRequest()).withLink(this.getLink()).withEntityDescription(this.getEntityDescription()).withFileSet(this.getFileSet()).withProjects(this.getProjects()).withAdditionalIdentifiers(this.getAdditionalIdentifiers()).withSubjects(this.getSubjects());
    }

    public void updateStatus(PublicationStatus nextStatus) throws InvalidPublicationStatusTransitionException {
        this.verifyStatusTransition(nextStatus);
        this.setStatus(nextStatus);
    }

    @JacocoGenerated
    public int hashCode() {
        return Objects.hash(new Object[]{this.getIdentifier(), this.getStatus(), this.getOwner(), this.getPublisher(), this.getCreatedDate(), this.getModifiedDate(), this.getPublishedDate(), this.getIndexedDate(), this.getHandle(), this.getDoi(), this.getDoiRequest(), this.getLink(), this.getEntityDescription(), this.getFileSet(), this.getProjects(), this.getAdditionalIdentifiers(), this.getSubjects()});
    }

    @JacocoGenerated
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Publication)) {
            return false;
        }
        Publication that = (Publication)o;
        boolean firstHalf = Objects.equals(this.getIdentifier(), that.getIdentifier()) && this.getStatus() == that.getStatus() && Objects.equals(this.getOwner(), that.getOwner()) && Objects.equals(this.getPublisher(), that.getPublisher()) && Objects.equals(this.getCreatedDate(), that.getCreatedDate()) && Objects.equals(this.getModifiedDate(), that.getModifiedDate()) && Objects.equals(this.getPublishedDate(), that.getPublishedDate());
        boolean secondHalf = Objects.equals(this.getIndexedDate(), that.getIndexedDate()) && Objects.equals(this.getHandle(), that.getHandle()) && Objects.equals(this.getDoi(), that.getDoi()) && Objects.equals(this.getDoiRequest(), that.getDoiRequest()) && Objects.equals(this.getLink(), that.getLink()) && Objects.equals(this.getEntityDescription(), that.getEntityDescription()) && Objects.equals(this.getFileSet(), that.getFileSet()) && Objects.equals(this.getProjects(), that.getProjects()) && Objects.equals(this.getAdditionalIdentifiers(), that.getAdditionalIdentifiers()) && Objects.equals(this.getSubjects(), that.getSubjects());
        return firstHalf && secondHalf;
    }

    private void verifyStatusTransition(PublicationStatus nextStatus) throws InvalidPublicationStatusTransitionException {
        PublicationStatus currentStatus = this.getStatus();
        if (!validStatusTransitionsMap.get((Object)currentStatus).contains((Object)nextStatus)) {
            throw new InvalidPublicationStatusTransitionException(currentStatus, nextStatus);
        }
    }

    public static final class Builder {
        private SortableIdentifier identifier;
        private PublicationStatus status;
        private String owner;
        private Organization publisher;
        private Instant createdDate;
        private Instant modifiedDate;
        private Instant publishedDate;
        private Instant indexedDate;
        private URI handle;
        private URI doi;
        private DoiRequest doiRequest;
        private URI link;
        private EntityDescription entityDescription;
        private FileSet fileSet;
        private List<ResearchProject> projects;
        private Set<AdditionalIdentifier> additionalIdentifiers;
        private List<URI> subjects;

        public Builder withIdentifier(SortableIdentifier identifier) {
            this.identifier = identifier;
            return this;
        }

        public Builder withStatus(PublicationStatus status) {
            this.status = status;
            return this;
        }

        public Builder withOwner(String owner) {
            this.owner = owner;
            return this;
        }

        public Builder withPublisher(Organization publisher) {
            this.publisher = publisher;
            return this;
        }

        public Builder withCreatedDate(Instant createdDate) {
            this.createdDate = createdDate;
            return this;
        }

        public Builder withModifiedDate(Instant modifiedDate) {
            this.modifiedDate = modifiedDate;
            return this;
        }

        public Builder withPublishedDate(Instant publishedDate) {
            this.publishedDate = publishedDate;
            return this;
        }

        public Builder withIndexedDate(Instant indexedDate) {
            this.indexedDate = indexedDate;
            return this;
        }

        public Builder withHandle(URI handle) {
            this.handle = handle;
            return this;
        }

        public Builder withDoi(URI doi) {
            this.doi = doi;
            return this;
        }

        public Builder withDoiRequest(DoiRequest doiRequest) {
            this.doiRequest = doiRequest;
            return this;
        }

        public Builder withLink(URI link) {
            this.link = link;
            return this;
        }

        public Builder withEntityDescription(EntityDescription entityDescription) {
            this.entityDescription = entityDescription;
            return this;
        }

        public Builder withFileSet(FileSet fileSet) {
            this.fileSet = fileSet;
            return this;
        }

        public Builder withProjects(List<ResearchProject> projects) {
            this.projects = projects;
            return this;
        }

        public Builder withAdditionalIdentifiers(Set<AdditionalIdentifier> additionalIdentifiers) {
            this.additionalIdentifiers = additionalIdentifiers;
            return this;
        }

        public Builder withSubjects(List<URI> subjects) {
            this.subjects = subjects;
            return this;
        }

        public Publication build() {
            return new Publication(this);
        }
    }
}

