/*
 * Decompiled with CFR 0.152.
 */
package no.unit.nva.model.contexttypes;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.net.URI;
import java.util.Objects;
import java.util.regex.Pattern;
import no.unit.nva.model.contexttypes.BookSeries;
import no.unit.nva.model.exceptions.InvalidSeriesException;
import nva.commons.core.JacocoGenerated;

@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, property="type")
public class Series
implements BookSeries {
    public static final Pattern EXPECTED_SERIES_URI_PATTERN = Pattern.compile("https://.*?nva\\.aws\\.unit\\.no/publication-channels/.*");
    private final URI id;

    @JsonCreator
    public Series(@JsonProperty(value="id") URI id) {
        this.validateSeriesUri(id);
        this.id = id;
    }

    public URI getId() {
        return this.id;
    }

    private void validateSeriesUri(URI seriesUri) {
        if (!EXPECTED_SERIES_URI_PATTERN.matcher(seriesUri.toString()).matches()) {
            throw new InvalidSeriesException(seriesUri.toString());
        }
    }

    @Override
    public boolean isConfirmed() {
        return true;
    }

    @JacocoGenerated
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Series)) {
            return false;
        }
        Series series = (Series)o;
        return Objects.equals(this.getId(), series.getId());
    }

    @JacocoGenerated
    public int hashCode() {
        return Objects.hash(this.getId());
    }
}

