/*
 * Decompiled with CFR 0.152.
 */
package no.unit.nva.model.instancetypes.journal;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.Arrays;
import java.util.stream.Collectors;

public enum JournalArticleContentType {
    ACADEMIC_ARTICLE("AcademicArticle", "Research article"),
    ACADEMIC_LITERATURE_REVIEW("AcademicLiteratureReview", "Review article"),
    CASE_REPORT("CaseReport", "Case report"),
    STUDY_PROTOCOL("StudyProtocol", "Study protocol"),
    PROFESSIONAL_ARTICLE("ProfessionalArticle", "Professional article"),
    POPULAR_SCIENCE_ARTICLE("PopularScienceArticle", "Popular science article");

    public static final String ERROR_MESSAGE_TEMPLATE = "%s not a valid JournalArticleContentType, expected one of: %s";
    public static final String DELIMITER = ", ";
    private final String value;
    private final String deprecatedValue;

    private JournalArticleContentType(String value, String deprecatedValue) {
        this.deprecatedValue = deprecatedValue;
        this.value = value;
    }

    @JsonCreator
    public static JournalArticleContentType lookup(String value) {
        return Arrays.stream(JournalArticleContentType.values()).filter(nameType -> JournalArticleContentType.equalsCurrentOrDeprecatedValue(value, nameType)).findAny().orElseThrow(() -> new IllegalArgumentException(JournalArticleContentType.createErrorMessage(value)));
    }

    @JsonValue
    public String getValue() {
        return this.value;
    }

    @Deprecated
    public String getDeprecatedValue() {
        return this.deprecatedValue;
    }

    private static boolean equalsCurrentOrDeprecatedValue(String value, JournalArticleContentType nameType) {
        return nameType.getValue().equalsIgnoreCase(value) || nameType.getDeprecatedValue().equalsIgnoreCase(value);
    }

    private static String createErrorMessage(String value) {
        return String.format(ERROR_MESSAGE_TEMPLATE, value, Arrays.stream(JournalArticleContentType.values()).map(Enum::toString).collect(Collectors.joining(DELIMITER)));
    }
}

