/*
 * Decompiled with CFR 0.152.
 */
package no.unit.nva.model.instancetypes.book;

import com.fasterxml.jackson.annotation.JsonValue;
import java.util.Arrays;
import java.util.stream.Collectors;

public enum BookMonographContentType {
    ACADEMIC_MONOGRAPH("Academic Monograph"),
    NON_FICTION_MONOGRAPH("Non-fiction Monograph"),
    POPULAR_SCIENCE_MONOGRAPH("Popular Science Monograph"),
    TEXTBOOK("Textbook"),
    ENCYCLOPEDIA("Encyclopedia"),
    EXHIBITION_CATALOG("Exhibition catalog");

    public static final String ERROR_MESSAGE_TEMPLATE = "%s not a valid BookMonographContentType, expected one of: %s";
    public static final String DELIMITER = ", ";
    private final String value;

    private BookMonographContentType(String value) {
        this.value = value;
    }

    public static BookMonographContentType lookup(String value) {
        return Arrays.stream(BookMonographContentType.values()).filter(nameType -> nameType.getValue().equalsIgnoreCase(value)).findAny().orElseThrow(() -> new IllegalArgumentException(String.format(ERROR_MESSAGE_TEMPLATE, value, Arrays.stream(BookMonographContentType.values()).map(Enum::toString).collect(Collectors.joining(DELIMITER)))));
    }

    @JsonValue
    public String getValue() {
        return this.value;
    }
}

