/*
 * Decompiled with CFR 0.152.
 */
package no.unit.nva.model.instancetypes.chapter;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.Arrays;
import java.util.stream.Collectors;

public enum ChapterArticleContentType {
    ACADEMIC_CHAPTER("Academic Chapter"),
    NON_FICTION_CHAPTER("Non-fiction Chapter"),
    POPULAR_SCIENCE_CHAPTER("Popular Science Chapter"),
    TEXTBOOK_CHAPTER("Textbook Chapter"),
    ENCYCLOPEDIA_CHAPTER("Encyclopedia Chapter"),
    INTRODUCTION("Introduction"),
    EXHIBITION_CATALOG_CHAPTER("Exhibition Catalog Chapter");

    public static final String ERROR_MESSAGE_TEMPLATE = "%s not a valid ChapterContentType, expected one of: %s";
    public static final String DELIMITER = ", ";
    private final String value;

    @JsonCreator
    private ChapterArticleContentType(String value) {
        this.value = value;
    }

    @JsonValue
    public String getValue() {
        return this.value;
    }

    public static ChapterArticleContentType lookup(String value) {
        return Arrays.stream(ChapterArticleContentType.values()).filter(nameType -> nameType.getValue().equalsIgnoreCase(value)).findAny().orElseThrow(() -> new IllegalArgumentException(String.format(ERROR_MESSAGE_TEMPLATE, value, Arrays.stream(ChapterArticleContentType.values()).map(Enum::toString).collect(Collectors.joining(DELIMITER)))));
    }
}

