/*
 * Decompiled with CFR 0.152.
 */
package no.unit.nva.model.instancetypes.exhibition;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.Arrays;
import java.util.stream.Collectors;
import nva.commons.core.SingletonCollector;
import nva.commons.core.attempt.Try;

public enum ExhibitionProductionSubtypeEnum {
    BASIC_EXHIBITION("BasicExhibition"),
    TEMPORARY_EXHIBITION("TemporaryExhibition"),
    POPUP_EXHIBITION("PopupExhibition"),
    AMBULATING_EXHIBITION("AmbulatingExhibition"),
    DIGITAL_EXHIBITION("DigitalExhibition"),
    HISTORICAL_INTERIOR("HistoricalInterior"),
    OTHER("Other");

    private final String type;

    private ExhibitionProductionSubtypeEnum(String type) {
        this.type = type;
    }

    @JsonValue
    public String getType() {
        return this.type;
    }

    @JsonCreator
    public ExhibitionProductionSubtypeEnum lookup(String candidate) {
        return (ExhibitionProductionSubtypeEnum)((Object)((Try)Arrays.stream(ExhibitionProductionSubtypeEnum.values()).filter(item -> item.getType().equalsIgnoreCase(candidate)).collect(SingletonCollector.tryCollect())).orElseThrow(failure -> this.getFailure()));
    }

    private RuntimeException getFailure() {
        return new RuntimeException("Could not parse ExhibitionProductionSubtype, allowed values: " + this.getValuesString());
    }

    private String getValuesString() {
        return Arrays.stream(ExhibitionProductionSubtypeEnum.values()).map(ExhibitionProductionSubtypeEnum::getType).collect(Collectors.joining(", "));
    }
}

