/*
 * Decompiled with CFR 0.152.
 */
package no.unit.nva.model.instancetypes.chapter;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.util.Objects;
import no.unit.nva.model.instancetypes.PublicationInstance;
import no.unit.nva.model.instancetypes.chapter.AcademicChapter;
import no.unit.nva.model.instancetypes.chapter.ChapterArticleContentType;
import no.unit.nva.model.instancetypes.chapter.EncyclopediaChapter;
import no.unit.nva.model.instancetypes.chapter.ExhibitionCatalogChapter;
import no.unit.nva.model.instancetypes.chapter.Introduction;
import no.unit.nva.model.instancetypes.chapter.NonFictionChapter;
import no.unit.nva.model.instancetypes.chapter.PopularScienceChapter;
import no.unit.nva.model.instancetypes.chapter.TextbookChapter;
import no.unit.nva.model.pages.Range;
import nva.commons.core.JacocoGenerated;

@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, property="type")
public class ChapterArticle
implements PublicationInstance<Range> {
    public static final String PAGES_FIELD = "pages";
    private final Range pages;

    public ChapterArticle(Range pages) {
        this.pages = pages;
    }

    @JsonCreator
    public static ChapterArticle fromJson(@JsonProperty(value="pages") Range pages, @JsonProperty(value="contentType") ChapterArticleContentType contentType) {
        if (ChapterArticleContentType.ACADEMIC_CHAPTER.equals((Object)contentType)) {
            return new AcademicChapter(pages);
        }
        if (ChapterArticleContentType.ENCYCLOPEDIA_CHAPTER.equals((Object)contentType)) {
            return new EncyclopediaChapter(pages);
        }
        if (ChapterArticleContentType.EXHIBITION_CATALOG_CHAPTER.equals((Object)contentType)) {
            return new ExhibitionCatalogChapter(pages);
        }
        if (ChapterArticleContentType.INTRODUCTION.equals((Object)contentType)) {
            return new Introduction(pages);
        }
        if (ChapterArticleContentType.NON_FICTION_CHAPTER.equals((Object)contentType)) {
            return new NonFictionChapter(pages);
        }
        if (ChapterArticleContentType.POPULAR_SCIENCE_CHAPTER.equals((Object)contentType)) {
            return new PopularScienceChapter(pages);
        }
        if (ChapterArticleContentType.TEXTBOOK_CHAPTER.equals((Object)contentType)) {
            return new TextbookChapter(pages);
        }
        if (Objects.isNull((Object)contentType)) {
            return new AcademicChapter(pages);
        }
        throw new UnsupportedOperationException("The Chapter article subtype is unknown");
    }

    @Override
    public Range getPages() {
        return this.pages;
    }

    @JacocoGenerated
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ChapterArticle)) {
            return false;
        }
        ChapterArticle that = (ChapterArticle)o;
        return Objects.equals(this.getPages(), that.getPages());
    }

    @JacocoGenerated
    public int hashCode() {
        return Objects.hash(this.getPages());
    }
}

