/*
 * Decompiled with CFR 0.152.
 */
package no.unit.nva.model.associatedartifacts.file;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.net.URI;
import java.time.Instant;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Supplier;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import no.unit.nva.commons.json.JsonSerializable;
import no.unit.nva.model.associatedartifacts.AssociatedArtifact;
import no.unit.nva.model.associatedartifacts.file.AdministrativeAgreement;
import no.unit.nva.model.associatedartifacts.file.MissingLicenseException;
import no.unit.nva.model.associatedartifacts.file.PublishedFile;
import no.unit.nva.model.associatedartifacts.file.UnpublishedFile;
import nva.commons.core.JacocoGenerated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, property="type")
@JsonSubTypes(value={@JsonSubTypes.Type(name="PublishedFile", value=PublishedFile.class), @JsonSubTypes.Type(names={"UnpublishedFile", "File"}, value=UnpublishedFile.class), @JsonSubTypes.Type(name="UnpublishableFile", value=AdministrativeAgreement.class)})
public abstract class File
implements JsonSerializable,
AssociatedArtifact {
    public static final String IDENTIFIER_FIELD = "identifier";
    public static final String NAME_FIELD = "name";
    public static final String MIME_TYPE_FIELD = "mimeType";
    public static final String SIZE_FIELD = "size";
    public static final String LICENSE_FIELD = "license";
    public static final String ADMINISTRATIVE_AGREEMENT_FIELD = "administrativeAgreement";
    public static final String PUBLISHER_AUTHORITY_FIELD = "publisherAuthority";
    public static final String EMBARGO_DATE_FIELD = "embargoDate";
    public static final Map<String, URI> LICENSE_MAP = Map.of("CC BY", URI.create("https://creativecommons.org/licenses/by/4.0"), "CC BY-NC", URI.create("https://creativecommons.org/licenses/by-nc/4.0"), "CC BY-NC-ND", URI.create("https://creativecommons.org/licenses/by-nc-nd/4.0"), "CC BY-NC-SA", URI.create("https://creativecommons.org/licenses/by-nc-sa/4.0"), "CC BY-ND", URI.create("https://creativecommons.org/licenses/by-nd/4.0"), "CC BY-SA", URI.create("https://creativecommons.org/licenses/by-sa/4.0"), "CC0", URI.create("https://creativecommons.org/publicdomain/zero/1.0"), "RightsReserved", URI.create("https://rightsstatements.org/page/InC/1.0"));
    public static final String MISSING_LICENSE = "The file is not annotated as an administrative agreement and should have a license";
    public static final Logger logger = LoggerFactory.getLogger(File.class);
    private static final Supplier<Pattern> LICENSE_VALIDATION_PATTERN = () -> Pattern.compile("^(http|https)://.*$");
    @JsonProperty(value="identifier")
    private final UUID identifier;
    @JsonProperty(value="name")
    private final String name;
    @JsonProperty(value="mimeType")
    private final String mimeType;
    @JsonProperty(value="size")
    private final Long size;
    @JsonProperty(value="license")
    private final URI license;
    @JsonProperty(value="administrativeAgreement")
    private final boolean administrativeAgreement;
    @JsonProperty(value="publisherAuthority")
    private final boolean publisherAuthority;
    @JsonProperty(value="embargoDate")
    private final Instant embargoDate;

    protected File(@JsonProperty(value="identifier") UUID identifier, @JsonProperty(value="name") String name, @JsonProperty(value="mimeType") String mimeType, @JsonProperty(value="size") Long size, @JsonProperty(value="license") Object license, @JsonProperty(value="administrativeAgreement") boolean administrativeAgreement, @JsonProperty(value="publisherAuthority") boolean publisherAuthority, @JsonProperty(value="embargoDate") Instant embargoDate) {
        this.identifier = identifier;
        this.name = name;
        this.mimeType = mimeType;
        this.size = size;
        this.license = this.validateUriLicense(this.parseLicense(license));
        this.administrativeAgreement = administrativeAgreement;
        this.publisherAuthority = publisherAuthority;
        this.embargoDate = embargoDate;
    }

    public static Builder builder() {
        return new Builder();
    }

    public void validate() {
        if (!this.administrativeAgreement && Objects.isNull(this.license)) {
            throw new MissingLicenseException(MISSING_LICENSE);
        }
    }

    public UUID getIdentifier() {
        return this.identifier;
    }

    public String getName() {
        return this.name;
    }

    public String getMimeType() {
        return this.mimeType;
    }

    public Long getSize() {
        return this.size;
    }

    public URI getLicense() {
        return this.license;
    }

    public boolean isAdministrativeAgreement() {
        return this.administrativeAgreement;
    }

    public boolean isPublisherAuthority() {
        return this.publisherAuthority;
    }

    public Optional<Instant> getEmbargoDate() {
        return Optional.ofNullable(this.embargoDate);
    }

    public boolean fileDoesNotHaveActiveEmbargo() {
        return this.getEmbargoDate().map(date -> Instant.now().isAfter((Instant)date)).orElse(true);
    }

    public UnpublishedFile toUnpublishedFile() {
        return new UnpublishedFile(this.getIdentifier(), this.getName(), this.getMimeType(), this.getSize(), this.getLicense(), this.isAdministrativeAgreement(), this.isPublisherAuthority(), this.getEmbargoDate().orElse(null));
    }

    public PublishedFile toPublishedFile() {
        return new PublishedFile(this.getIdentifier(), this.getName(), this.getMimeType(), this.getSize(), this.getLicense(), this.isAdministrativeAgreement(), this.isPublisherAuthority(), this.getEmbargoDate().orElse(null), Instant.now());
    }

    public final AdministrativeAgreement toUnpublishableFile() {
        if (this.isAdministrativeAgreement()) {
            return new AdministrativeAgreement(this.getIdentifier(), this.getName(), this.getMimeType(), this.getSize(), this.getLicense(), this.isAdministrativeAgreement(), this.isPublisherAuthority(), this.getEmbargoDate().orElse(null));
        }
        throw new IllegalStateException("Cannot make unpublishable a non-administrative agreement");
    }

    public abstract boolean isVisibleForNonOwner();

    @JacocoGenerated
    public int hashCode() {
        return Objects.hash(this.getIdentifier(), this.getName(), this.getMimeType(), this.getSize(), this.getLicense(), this.isAdministrativeAgreement(), this.isPublisherAuthority(), this.getEmbargoDate());
    }

    @JacocoGenerated
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof File)) {
            return false;
        }
        File file = (File)o;
        return this.isAdministrativeAgreement() == file.isAdministrativeAgreement() && this.isPublisherAuthority() == file.isPublisherAuthority() && Objects.equals(this.getIdentifier(), file.getIdentifier()) && Objects.equals(this.getName(), file.getName()) && Objects.equals(this.getMimeType(), file.getMimeType()) && Objects.equals(this.getSize(), file.getSize()) && Objects.equals(this.getLicense(), file.getLicense()) && Objects.equals(this.getEmbargoDate(), file.getEmbargoDate());
    }

    public String toString() {
        return this.toJsonString();
    }

    private URI parseLicense(Object license) {
        if (Objects.isNull(license)) {
            return null;
        }
        if (license instanceof LinkedHashMap) {
            String licenseName = this.getLicenseValue((LinkedHashMap)license);
            return LICENSE_MAP.get(licenseName);
        }
        return URI.create(license.toString());
    }

    private String getLicenseValue(Map<?, ?> license) {
        return (String)license.get(IDENTIFIER_FIELD);
    }

    private URI validateUriLicense(URI license) {
        if (Objects.nonNull(license) && this.isValidUriLicense(license)) {
            return this.formatValidUriLicense(license);
        }
        logger.info("The specified license can not be converted into valid URI license: {}", (Object)license);
        return license;
    }

    private boolean isValidUriLicense(URI license) {
        Matcher matcher = LICENSE_VALIDATION_PATTERN.get().matcher(license.toString());
        return matcher.matches();
    }

    private URI formatValidUriLicense(URI license) {
        String formatedLicenseURL = license.toString().replaceFirst(license.getScheme(), "https").replaceAll("/$", "").toLowerCase(Locale.ROOT);
        return URI.create(formatedLicenseURL);
    }

    public static final class Builder {
        private UUID identifier;
        private String name;
        private String mimeType;
        private Long size;
        private URI license;
        private boolean administrativeAgreement;
        private boolean publisherAuthority;
        private Instant embargoDate;

        private Builder() {
        }

        public Builder withIdentifier(UUID identifier) {
            this.identifier = identifier;
            return this;
        }

        public Builder withName(String name) {
            this.name = name;
            return this;
        }

        public Builder withMimeType(String mimeType) {
            this.mimeType = mimeType;
            return this;
        }

        public Builder withSize(Long size) {
            this.size = size;
            return this;
        }

        public Builder withLicense(URI license) {
            this.license = license;
            return this;
        }

        public Builder withAdministrativeAgreement(boolean administrativeAgreement) {
            this.administrativeAgreement = administrativeAgreement;
            return this;
        }

        public Builder withPublisherAuthority(boolean publisherAuthority) {
            this.publisherAuthority = publisherAuthority;
            return this;
        }

        public Builder withEmbargoDate(Instant embargoDate) {
            this.embargoDate = embargoDate;
            return this;
        }

        public File buildPublishedFile() {
            return new PublishedFile(this.identifier, this.name, this.mimeType, this.size, this.license, this.administrativeAgreement, this.publisherAuthority, this.embargoDate, Instant.now());
        }

        public File buildUnpublishedFile() {
            return new UnpublishedFile(this.identifier, this.name, this.mimeType, this.size, this.license, this.administrativeAgreement, this.publisherAuthority, this.embargoDate);
        }

        public File buildUnpublishableFile() {
            return new AdministrativeAgreement(this.identifier, this.name, this.mimeType, this.size, this.license, this.administrativeAgreement, this.publisherAuthority, this.embargoDate);
        }
    }
}

