/*
 * Decompiled with CFR 0.152.
 */
package no.unit.nva.model.pages;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.util.Objects;
import no.unit.nva.model.pages.Pages;
import nva.commons.core.JacocoGenerated;

@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, property="type")
public class Range
implements Pages {
    public static final String NON_SPACE_WHITESPACE = "[\\n\\r\\t]+";
    public static final String EMPTY_STRING = "";
    private final String begin;
    private final String end;

    @JsonCreator
    public Range(@JsonProperty(value="begin") String begin, @JsonProperty(value="end") String end) {
        String sanitizedBegin = this.sanitize(begin);
        String sanitizedEnd = this.sanitize(end);
        this.begin = this.verifyOrCreateSinglePageRange(sanitizedBegin, sanitizedEnd);
        this.end = this.verifyOrCreateSinglePageRange(sanitizedEnd, sanitizedBegin);
    }

    private String verifyOrCreateSinglePageRange(String input, String comparison) {
        return Objects.nonNull(input) ? input : comparison;
    }

    private String sanitize(String input) {
        return Objects.nonNull(input) ? this.removeWhiteSpace(input) : null;
    }

    private String removeWhiteSpace(String input) {
        String trimmed = input.replaceAll(NON_SPACE_WHITESPACE, EMPTY_STRING).trim();
        return trimmed.isEmpty() ? null : trimmed;
    }

    private Range(Builder builder) {
        this(builder.begin, builder.end);
    }

    public String getBegin() {
        return this.begin;
    }

    public String getEnd() {
        return this.end;
    }

    @JacocoGenerated
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Range)) {
            return false;
        }
        Range range = (Range)o;
        return Objects.equals(this.begin, range.begin) && Objects.equals(this.end, range.end);
    }

    @JacocoGenerated
    public int hashCode() {
        return Objects.hash(this.begin, this.end);
    }

    public static final class Builder {
        private String begin;
        private String end;

        public Builder withBegin(String begin) {
            this.begin = begin;
            return this;
        }

        public Builder withEnd(String end) {
            this.end = end;
            return this;
        }

        public Range build() {
            return new Range(this);
        }
    }
}

