/*
 * Decompiled with CFR 0.152.
 */
package no.unit.nva.model;

import com.fasterxml.jackson.annotation.JsonAlias;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.time.Instant;
import java.util.Objects;
import no.unit.nva.model.ApprovalStatus;
import no.unit.nva.model.ApprovalsBody;
import nva.commons.core.JacocoGenerated;

@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, property="type")
public class Approval {
    @JsonAlias(value={"date"})
    private Instant approvalDate;
    private ApprovalsBody approvedBy;
    private ApprovalStatus approvalStatus;
    private String applicationCode;

    public Approval() {
    }

    private Approval(Builder builder) {
        this.setApprovalDate(builder.approvalDate);
        this.setApprovedBy(builder.approvedBy);
        this.setApprovalStatus(builder.approvalStatus);
        this.setApplicationCode(builder.applicationCode);
    }

    public Instant getApprovalDate() {
        return this.approvalDate;
    }

    public void setApprovalDate(Instant approvalDate) {
        this.approvalDate = approvalDate;
    }

    public ApprovalsBody getApprovedBy() {
        return this.approvedBy;
    }

    public void setApprovedBy(ApprovalsBody approvedBy) {
        this.approvedBy = approvedBy;
    }

    public ApprovalStatus getApprovalStatus() {
        return this.approvalStatus;
    }

    public void setApprovalStatus(ApprovalStatus approvalStatus) {
        this.approvalStatus = approvalStatus;
    }

    public String getApplicationCode() {
        return this.applicationCode;
    }

    public void setApplicationCode(String applicationCode) {
        this.applicationCode = applicationCode;
    }

    @JacocoGenerated
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Approval)) {
            return false;
        }
        Approval approval = (Approval)o;
        return Objects.equals(this.getApprovalDate(), approval.getApprovalDate()) && Objects.equals((Object)this.getApprovedBy(), (Object)approval.getApprovedBy()) && Objects.equals((Object)this.getApprovalStatus(), (Object)approval.getApprovalStatus()) && Objects.equals(this.getApplicationCode(), approval.getApplicationCode());
    }

    @JacocoGenerated
    public int hashCode() {
        return Objects.hash(new Object[]{this.getApprovalDate(), this.getApprovedBy(), this.getApprovalStatus(), this.getApplicationCode()});
    }

    public static final class Builder {
        private Instant approvalDate;
        private ApprovalsBody approvedBy;
        private ApprovalStatus approvalStatus;
        private String applicationCode;

        public Builder withApprovalDate(Instant approvalDate) {
            this.approvalDate = approvalDate;
            return this;
        }

        public Builder withApprovedBy(ApprovalsBody approvedBy) {
            this.approvedBy = approvedBy;
            return this;
        }

        public Builder withApprovalStatus(ApprovalStatus approvalStatus) {
            this.approvalStatus = approvalStatus;
            return this;
        }

        public Builder withApplicationCode(String applicationCode) {
            this.applicationCode = applicationCode;
            return this;
        }

        public Approval build() {
            return new Approval(this);
        }
    }
}

