/*
 * Decompiled with CFR 0.152.
 */
package no.unit.nva.model;

import com.fasterxml.jackson.annotation.JsonAlias;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.net.URI;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import no.unit.nva.model.Contributor;
import no.unit.nva.model.PublicationDate;
import no.unit.nva.model.Reference;
import no.unit.nva.model.WithCopy;
import nva.commons.core.JacocoGenerated;

@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, property="type")
public class EntityDescription
implements WithCopy<Builder> {
    private String mainTitle;
    private Map<String, String> alternativeTitles;
    private URI language;
    @JsonAlias(value={"date"})
    private PublicationDate publicationDate;
    private List<Contributor> contributors;
    @JsonSetter(value="abstract")
    private String mainLanguageAbstract;
    private Map<String, String> alternativeAbstracts;
    private String npiSubjectHeading;
    private List<String> tags;
    private String description;
    private Reference reference;
    private URI metadataSource;

    public EntityDescription() {
        this.contributors = Collections.emptyList();
        this.tags = Collections.emptyList();
        this.alternativeTitles = Collections.emptyMap();
        this.alternativeAbstracts = Collections.emptyMap();
    }

    private EntityDescription(Builder builder) {
        this.setMainTitle(builder.mainTitle);
        this.setAlternativeTitles(builder.alternativeTitles);
        this.setLanguage(builder.language);
        this.setPublicationDate(builder.publicationDate);
        this.setContributors(builder.contributors);
        this.setAbstract(builder.mainLanguageAbstract);
        this.setNpiSubjectHeading(builder.npiSubjectHeading);
        this.setTags(builder.tags);
        this.setDescription(builder.description);
        this.setReference(builder.reference);
        this.setMetadataSource(builder.metadataSource);
        this.setAlternativeAbstracts(builder.alternativeAbstracts);
    }

    public String getMainTitle() {
        return this.mainTitle;
    }

    public void setMainTitle(String mainTitle) {
        this.mainTitle = mainTitle;
    }

    public Map<String, String> getAlternativeTitles() {
        return Objects.nonNull(this.alternativeTitles) ? this.alternativeTitles : Collections.emptyMap();
    }

    public Map<String, String> getAlternativeAbstracts() {
        return Objects.nonNull(this.alternativeAbstracts) ? this.alternativeAbstracts : Collections.emptyMap();
    }

    public void setAlternativeAbstracts(Map<String, String> alternativeAbstracts) {
        this.alternativeAbstracts = alternativeAbstracts;
    }

    public void setAlternativeTitles(Map<String, String> alternativeTitles) {
        this.alternativeTitles = alternativeTitles;
    }

    public URI getLanguage() {
        return this.language;
    }

    public void setLanguage(URI language) {
        this.language = language;
    }

    public PublicationDate getPublicationDate() {
        return this.publicationDate;
    }

    public void setPublicationDate(PublicationDate publicationDate) {
        this.publicationDate = publicationDate;
    }

    public List<Contributor> getContributors() {
        return Objects.nonNull(this.contributors) ? this.contributors : Collections.emptyList();
    }

    public void setContributors(List<Contributor> contributors) {
        this.contributors = Objects.nonNull(contributors) ? contributors.stream().sorted(this::compareContributors).collect(Collectors.toList()) : contributors;
    }

    private int compareContributors(Contributor contributor, Contributor otherContributor) {
        Integer sequence = contributor.getSequence();
        Integer otherSequence = otherContributor.getSequence();
        if (Objects.isNull(sequence) || Objects.isNull(otherSequence) || sequence.equals(otherSequence)) {
            return Integer.compare(contributor.hashCode(), otherContributor.hashCode());
        }
        return sequence.compareTo(otherSequence);
    }

    public URI getMetadataSource() {
        return this.metadataSource;
    }

    public void setMetadataSource(URI metadataSource) {
        this.metadataSource = metadataSource;
    }

    public String getAbstract() {
        return this.mainLanguageAbstract;
    }

    public void setAbstract(String mainLanguageAbstract) {
        this.mainLanguageAbstract = mainLanguageAbstract;
    }

    public String getNpiSubjectHeading() {
        return this.npiSubjectHeading;
    }

    public void setNpiSubjectHeading(String npiSubjectHeading) {
        this.npiSubjectHeading = npiSubjectHeading;
    }

    public List<String> getTags() {
        return Objects.nonNull(this.tags) ? this.tags : Collections.emptyList();
    }

    public void setTags(List<String> tags) {
        this.tags = tags;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Reference getReference() {
        return this.reference;
    }

    public void setReference(Reference reference) {
        this.reference = reference;
    }

    @JacocoGenerated
    public int hashCode() {
        return Objects.hash(this.getMainTitle(), this.getAlternativeTitles(), this.getLanguage(), this.getPublicationDate(), this.getContributors(), this.getAbstract(), this.getNpiSubjectHeading(), this.getTags(), this.getDescription(), this.getReference(), this.getMetadataSource(), this.getAlternativeAbstracts());
    }

    @JacocoGenerated
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof EntityDescription)) {
            return false;
        }
        EntityDescription that = (EntityDescription)o;
        return Objects.equals(this.getMainTitle(), that.getMainTitle()) && Objects.equals(this.getAlternativeTitles(), that.getAlternativeTitles()) && Objects.equals(this.getLanguage(), that.getLanguage()) && Objects.equals(this.getPublicationDate(), that.getPublicationDate()) && Objects.equals(this.getContributors(), that.getContributors()) && Objects.equals(this.getAbstract(), that.getAbstract()) && Objects.equals(this.getNpiSubjectHeading(), that.getNpiSubjectHeading()) && Objects.equals(this.getTags(), that.getTags()) && Objects.equals(this.getDescription(), that.getDescription()) && Objects.equals(this.getReference(), that.getReference()) && Objects.equals(this.getMetadataSource(), that.getMetadataSource()) && Objects.equals(this.getAlternativeAbstracts(), that.getAlternativeAbstracts());
    }

    @Override
    public Builder copy() {
        return new Builder().withMainTitle(this.getMainTitle()).withAlternativeTitles(this.getAlternativeTitles()).withLanguage(this.getLanguage()).withPublicationDate(this.getPublicationDate()).withContributors(this.getContributors()).withAbstract(this.getAbstract()).withAlternativeAbstracts(this.getAlternativeAbstracts()).withNpiSubjectHeading(this.getNpiSubjectHeading()).withTags(this.getTags()).withDescription(this.getDescription()).withReference(this.getReference()).withMetadataSource(this.getMetadataSource());
    }

    public static final class Builder {
        private String mainTitle;
        private Map<String, String> alternativeTitles;
        private URI language;
        private PublicationDate publicationDate;
        private List<Contributor> contributors;
        private String mainLanguageAbstract;
        private Map<String, String> alternativeAbstracts;
        private String npiSubjectHeading;
        private List<String> tags;
        private String description;
        private Reference reference;
        private URI metadataSource;

        public Builder withMainTitle(String mainTitle) {
            this.mainTitle = mainTitle;
            return this;
        }

        public Builder withAlternativeTitles(Map<String, String> alternativeTitles) {
            this.alternativeTitles = alternativeTitles;
            return this;
        }

        public Builder withLanguage(URI language) {
            this.language = language;
            return this;
        }

        public Builder withPublicationDate(PublicationDate date) {
            this.publicationDate = date;
            return this;
        }

        public Builder withContributors(List<Contributor> contributors) {
            this.contributors = contributors;
            return this;
        }

        public Builder withAbstract(String mainLanguageAbstract) {
            this.mainLanguageAbstract = mainLanguageAbstract;
            return this;
        }

        public Builder withAlternativeAbstracts(Map<String, String> alternativeAbstracts) {
            this.alternativeAbstracts = alternativeAbstracts;
            return this;
        }

        public Builder withNpiSubjectHeading(String npiSubjectHeading) {
            this.npiSubjectHeading = npiSubjectHeading;
            return this;
        }

        public Builder withTags(List<String> tags) {
            this.tags = tags;
            return this;
        }

        public Builder withDescription(String description) {
            this.description = description;
            return this;
        }

        public Builder withReference(Reference reference) {
            this.reference = reference;
            return this;
        }

        public Builder withMetadataSource(URI metadataSource) {
            this.metadataSource = metadataSource;
            return this;
        }

        public EntityDescription build() {
            return new EntityDescription(this);
        }
    }
}

