/*
 * Decompiled with CFR 0.152.
 */
package no.unit.nva.model.contexttypes;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.net.URI;
import java.util.Objects;
import no.unit.nva.model.contexttypes.Periodical;
import no.unit.nva.model.contexttypes.utils.ChannelType;
import no.unit.nva.model.contexttypes.utils.MigrateChannelIdUtil;
import no.unit.nva.model.exceptions.InvalidSeriesException;
import nva.commons.core.JacocoGenerated;

@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, property="type")
public class Journal
implements Periodical {
    private final URI id;

    @JsonCreator
    public Journal(@JsonProperty(value="id") URI id) {
        Journal.validate(id);
        this.id = MigrateChannelIdUtil.isNewStyleIdentifier(id) ? id : MigrateChannelIdUtil.migrateToNewIdIfFound(id, ChannelType.JOURNAL);
    }

    public URI getId() {
        return this.id;
    }

    @JacocoGenerated
    public int hashCode() {
        return Objects.hash(this.getId());
    }

    @JacocoGenerated
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Journal)) {
            return false;
        }
        Journal journal = (Journal)o;
        return Objects.equals(this.getId(), journal.getId());
    }

    private static void validate(URI id) {
        String stringOfUri = id.toString();
        if (Objects.isNull(stringOfUri) || stringOfUri.isBlank()) {
            throw new InvalidSeriesException(stringOfUri);
        }
    }
}

