/*
 * Decompiled with CFR 0.152.
 */
package no.unit.nva.model.contexttypes;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.util.List;
import no.unit.nva.model.contexttypes.Book;
import no.unit.nva.model.contexttypes.BookSeries;
import no.unit.nva.model.contexttypes.PublishingHouse;
import no.unit.nva.model.exceptions.InvalidIsbnException;
import no.unit.nva.model.exceptions.InvalidUnconfirmedSeriesException;

@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, property="type")
public class Degree
extends Book {
    @JsonCreator
    public Degree(@JsonProperty(value="series") BookSeries series, @JsonProperty(value="seriesTitle", access=JsonProperty.Access.WRITE_ONLY) String unconfirmedSeriesTitle, @JsonProperty(value="seriesNumber") String seriesNumber, @JsonProperty(value="publisher") PublishingHouse publisher, @JsonProperty(value="isbnList") List<String> isbnList) throws InvalidIsbnException, InvalidUnconfirmedSeriesException {
        super(series, unconfirmedSeriesTitle, seriesNumber, publisher, isbnList);
    }

    private Degree(Builder builder) throws InvalidIsbnException, InvalidUnconfirmedSeriesException {
        super(builder.series, null, builder.seriesNumber, builder.publisher, builder.isbnList);
    }

    public static final class Builder {
        private BookSeries series;
        private String seriesNumber;
        private PublishingHouse publisher;
        private List<String> isbnList;

        public Builder withSeries(BookSeries series) {
            this.series = series;
            return this;
        }

        public Builder withSeriesNumber(String seriesNumber) {
            this.seriesNumber = seriesNumber;
            return this;
        }

        public Builder withPublisher(PublishingHouse publisher) {
            this.publisher = publisher;
            return this;
        }

        public Builder withIsbnList(List<String> isbnList) {
            this.isbnList = isbnList;
            return this;
        }

        public Degree build() throws InvalidIsbnException, InvalidUnconfirmedSeriesException {
            return new Degree(this);
        }
    }
}

