/*
 * Decompiled with CFR 0.152.
 */
package no.unit.nva.model.funding;

import java.net.URI;
import java.time.Instant;
import java.util.Map;
import java.util.Objects;
import no.unit.nva.model.funding.ConfirmedFunding;
import no.unit.nva.model.funding.Funding;
import no.unit.nva.model.funding.MonetaryAmount;
import no.unit.nva.model.funding.UnconfirmedFunding;

public final class FundingBuilder {
    private URI source;
    private URI id;
    private String identifier;
    private Map<String, String> labels;
    private MonetaryAmount fundingAmount;
    private Instant activeFrom;
    private Instant activeTo;

    public FundingBuilder withSource(URI source) {
        this.source = source;
        return this;
    }

    public FundingBuilder withId(URI id) {
        this.id = id;
        return this;
    }

    public FundingBuilder withIdentifier(String identifier) {
        this.identifier = identifier;
        return this;
    }

    public FundingBuilder withLabels(Map<String, String> labels) {
        this.labels = labels;
        return this;
    }

    public FundingBuilder withFundingAmount(MonetaryAmount fundingAmount) {
        this.fundingAmount = fundingAmount;
        return this;
    }

    public FundingBuilder withActiveFrom(Instant activeFrom) {
        this.activeFrom = activeFrom;
        return this;
    }

    public FundingBuilder withActiveTo(Instant activeTo) {
        this.activeTo = activeTo;
        return this;
    }

    public Funding build() {
        return Objects.nonNull(this.id) ? new ConfirmedFunding(this.source, this.id, this.identifier, this.labels, this.fundingAmount, this.activeFrom, this.activeTo) : new UnconfirmedFunding(this.source, this.identifier, this.labels, this.fundingAmount, this.activeFrom, this.activeTo);
    }
}

