/*
 * Decompiled with CFR 0.152.
 */
package no.unit.nva.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.Arrays;
import java.util.stream.Collectors;

public enum ContributorVerificationStatus {
    VERIFIED("Verified"),
    CANNOT_BE_ESTABLISHED("CannotBeEstablished"),
    NOT_VERIFIED("NotVerified");

    public static final String ERROR_MESSAGE_TEMPLATE = "%s not a valid ContributorVerificationStatus, expected one of: %s";
    public static final String DELIMITER = ", ";
    private final String value;

    private ContributorVerificationStatus(String value) {
        this.value = value;
    }

    @JsonCreator
    public static ContributorVerificationStatus parse(String candidate) {
        return Arrays.stream(ContributorVerificationStatus.values()).filter(nameType -> nameType.getValue().equalsIgnoreCase(candidate)).findAny().orElseThrow(() -> new IllegalArgumentException(String.format(ERROR_MESSAGE_TEMPLATE, candidate, Arrays.stream(ContributorVerificationStatus.values()).map(Enum::toString).collect(Collectors.joining(DELIMITER)))));
    }

    @JsonValue
    public String getValue() {
        return this.value;
    }
}

