/*
 * Decompiled with CFR 0.152.
 */
package no.unit.nva.model.contexttypes;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import no.unit.nva.model.AdditionalIdentifier;
import no.unit.nva.model.contexttypes.BasicContext;
import no.unit.nva.model.contexttypes.BookSeries;
import no.unit.nva.model.contexttypes.PublishingHouse;
import no.unit.nva.model.exceptions.InvalidUnconfirmedSeriesException;
import nva.commons.core.JacocoGenerated;
import org.apache.commons.validator.routines.ISBNValidator;

@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, property="type")
public class Book
implements BasicContext {
    public static final ISBNValidator ISBN_VALIDATOR = new ISBNValidator();
    public static final String JSON_PROPERTY_SERIES = "series";
    public static final String JSON_PROPERTY_SERIES_TITLE = "seriesTitle";
    public static final String JSON_PROPERTY_SERIES_NUMBER = "seriesNumber";
    public static final String JSON_PROPERTY_PUBLISHER = "publisher";
    public static final String JSON_PROPERTY_ISBN_LIST = "isbnList";
    public static final String JSON_PROPERTY_ADDITIONAL_IDENTIFIERS = "additionalIdentifiers";
    public static final String SPACES_AND_HYPHENS_REGEX = "[ -]";
    public static final String ISBN_SOURCE = "ISBN";
    @JsonProperty(value="series")
    private final BookSeries series;
    @JsonProperty(value="seriesNumber")
    private final String seriesNumber;
    @JsonProperty(value="publisher")
    private final PublishingHouse publisher;
    @JsonProperty(value="isbnList")
    private final List<String> isbnList;
    @JsonProperty(value="additionalIdentifiers")
    private final Set<AdditionalIdentifier> additionalIdentifiers;

    public Book(@JsonProperty(value="series") BookSeries series, @JsonProperty(value="seriesTitle", access=JsonProperty.Access.WRITE_ONLY) String unconfirmedSeriesTitle, @JsonProperty(value="seriesNumber") String seriesNumber, @JsonProperty(value="publisher") PublishingHouse publisher, @JsonProperty(value="isbnList") List<String> isbnList) throws InvalidUnconfirmedSeriesException {
        this(BookSeries.extractSeriesInformation(series, unconfirmedSeriesTitle), seriesNumber, publisher, isbnList);
    }

    public Book(BookSeries series, String seriesNumber, PublishingHouse publisher, List<String> isbnList) {
        this.series = series;
        this.seriesNumber = seriesNumber;
        this.publisher = publisher;
        this.isbnList = this.extractValidIsbnList(isbnList);
        this.additionalIdentifiers = Objects.nonNull(isbnList) ? this.extractInvalidIsbn(isbnList) : Set.of();
    }

    private Set<AdditionalIdentifier> extractInvalidIsbn(List<String> isbnList) {
        return isbnList.stream().filter(isbn -> !this.isbnList.contains(isbn)).map(isbn -> new AdditionalIdentifier(ISBN_SOURCE, (String)isbn)).collect(Collectors.toSet());
    }

    public Set<AdditionalIdentifier> getAdditionalIdentifiers() {
        return this.additionalIdentifiers;
    }

    public BookSeries getSeries() {
        return this.series;
    }

    public String getSeriesNumber() {
        return this.seriesNumber;
    }

    public PublishingHouse getPublisher() {
        return this.publisher;
    }

    public List<String> getIsbnList() {
        return Objects.nonNull(this.isbnList) ? this.isbnList : Collections.emptyList();
    }

    public BookBuilder copy() {
        return new BookBuilder().withSeriesNumber(this.getSeriesNumber()).withSeries(this.getSeries()).withPublisher(this.getPublisher()).withIsbnList(this.getIsbnList());
    }

    @JacocoGenerated
    public int hashCode() {
        return Objects.hash(this.getSeries(), this.getSeriesNumber(), this.getPublisher(), this.getIsbnList(), this.additionalIdentifiers);
    }

    @JacocoGenerated
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Book book = (Book)o;
        return Objects.equals(this.getSeries(), book.getSeries()) && Objects.equals(this.getSeriesNumber(), book.getSeriesNumber()) && Objects.equals(this.getPublisher(), book.getPublisher()) && Objects.equals(this.getIsbnList(), book.getIsbnList()) && Objects.equals(this.additionalIdentifiers, book.additionalIdentifiers);
    }

    private List<String> extractValidIsbnList(List<String> isbnList) {
        if (Objects.isNull(isbnList) || isbnList.isEmpty()) {
            return Collections.emptyList();
        }
        return isbnList.stream().map(isbn -> isbn.replaceAll(SPACES_AND_HYPHENS_REGEX, "")).map(arg_0 -> ((ISBNValidator)ISBN_VALIDATOR).validate(arg_0)).filter(Objects::nonNull).toList();
    }

    public static final class BookBuilder {
        private BookSeries series;
        private String seriesNumber;
        private PublishingHouse publisher;
        private List<String> isbnList;

        public BookBuilder withSeries(BookSeries series) {
            this.series = series;
            return this;
        }

        public BookBuilder withSeriesNumber(String seriesNumber) {
            this.seriesNumber = seriesNumber;
            return this;
        }

        public BookBuilder withPublisher(PublishingHouse publisher) {
            this.publisher = publisher;
            return this;
        }

        public BookBuilder withIsbnList(List<String> isbnList) {
            this.isbnList = isbnList;
            return this;
        }

        public Book build() {
            return new Book(this.series, this.seriesNumber, this.publisher, this.isbnList);
        }
    }
}

