/*
 * Decompiled with CFR 0.152.
 */
package no.unit.nva.model;

import com.fasterxml.jackson.annotation.JsonValue;
import java.util.Arrays;
import java.util.stream.Collectors;
import nva.commons.core.JacocoGenerated;

public enum PublicationStatus {
    NEW("NEW"),
    DRAFT("DRAFT"),
    PUBLISHED_METADATA("PUBLISHED_METADATA"),
    PUBLISHED("PUBLISHED"),
    DELETED("DELETED"),
    DRAFT_FOR_DELETION("DRAFT_FOR_DELETION");

    public static final String ERROR_MESSAGE_TEMPLATE = "%s not a valid PublicationStatus, expected one of: %s";
    public static final String DELIMITER = ", ";
    private String value;

    private PublicationStatus(String value) {
        this.value = value;
    }

    @JsonValue
    public String getValue() {
        return this.value;
    }

    @JacocoGenerated
    public void setValue(String value) {
        this.value = value;
    }

    public static PublicationStatus lookup(String value) {
        return Arrays.stream(PublicationStatus.values()).filter(publicationStatus -> publicationStatus.getValue().equalsIgnoreCase(value)).findAny().orElseThrow(() -> new IllegalArgumentException(String.format(ERROR_MESSAGE_TEMPLATE, value, Arrays.stream(PublicationStatus.values()).map(Enum::toString).collect(Collectors.joining(DELIMITER)))));
    }
}

