/*
 * Decompiled with CFR 0.152.
 */
package no.unit.nva.model.contexttypes;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.net.URI;
import java.util.Objects;
import no.unit.nva.model.contexttypes.BookSeries;
import no.unit.nva.model.exceptions.InvalidSeriesException;
import nva.commons.core.JacocoGenerated;

@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, property="type")
public class Series
implements BookSeries {
    private final URI id;

    @JsonCreator
    public Series(@JsonProperty(value="id") URI id) {
        Series.validate(id);
        this.id = id;
    }

    public URI getId() {
        return this.id;
    }

    @Override
    public boolean isConfirmed() {
        return true;
    }

    @JacocoGenerated
    public int hashCode() {
        return Objects.hash(this.getId());
    }

    @JacocoGenerated
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Series)) {
            return false;
        }
        Series series = (Series)o;
        return Objects.equals(this.getId(), series.getId());
    }

    private static void validate(URI id) {
        String stringOfUri = id.toString();
        if (Objects.isNull(stringOfUri) || stringOfUri.isBlank()) {
            throw new InvalidSeriesException(stringOfUri);
        }
    }
}

