/*
 * Decompiled with CFR 0.152.
 */
package no.unit.nva.model.funding;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.net.URI;
import java.time.Instant;
import java.util.Map;
import java.util.Objects;
import no.unit.nva.model.funding.MonetaryAmount;
import no.unit.nva.model.funding.UnconfirmedFunding;
import nva.commons.core.JacocoGenerated;

@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, property="type")
public class ConfirmedFunding
extends UnconfirmedFunding {
    private final URI id;

    @JsonCreator
    protected ConfirmedFunding(@JsonProperty(value="source") URI source, @JsonProperty(value="id") URI id, @JsonProperty(value="identifier") String identifier, @JsonProperty(value="labels") Map<String, String> labels, @JsonProperty(value="fundingAmount") MonetaryAmount fundingAmount, @JsonProperty(value="activeFrom") Instant activeFrom, @JsonProperty(value="activeTo") Instant activeTo) {
        super(source, identifier, labels, fundingAmount, activeFrom, activeTo);
        this.id = this.validate(id);
    }

    private URI validate(URI id) {
        if (Objects.isNull(id)) {
            throw new IllegalArgumentException("The funding object lacks an id");
        }
        return id;
    }

    public URI getId() {
        return this.id;
    }

    @Override
    @JacocoGenerated
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ConfirmedFunding)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ConfirmedFunding that = (ConfirmedFunding)o;
        return Objects.equals(this.getId(), that.getId());
    }

    @Override
    @JacocoGenerated
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.getId());
    }
}

