/*
 * Decompiled with CFR 0.152.
 */
package no.unit.nva.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import no.unit.nva.model.Identity;
import no.unit.nva.model.Organization;
import no.unit.nva.model.role.Role;
import no.unit.nva.model.role.RoleType;
import no.unit.nva.model.util.SerializationUtils;
import nva.commons.core.JacocoGenerated;

@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, property="type")
public class Contributor {
    private final Identity identity;
    private final List<Organization> affiliations;
    private final RoleType role;
    private final Integer sequence;
    private final boolean correspondingAuthor;

    @JsonCreator
    public Contributor(@JsonProperty(value="identity") Identity identity, @JsonProperty(value="affiliations") List<Organization> affiliations, @JsonProperty(value="role") Object role, @JsonProperty(value="sequence") Integer sequence, @JsonProperty(value="correspondingAuthor") boolean correspondingAuthor) {
        this.identity = identity;
        this.affiliations = SerializationUtils.nullListAsEmpty(affiliations);
        this.role = this.roleFromJson(role);
        this.sequence = sequence;
        this.correspondingAuthor = correspondingAuthor;
    }

    protected Contributor(Builder builder) {
        this(builder.identity, builder.affiliations, builder.role, builder.sequence, builder.correspondingAuthor);
    }

    public Identity getIdentity() {
        return this.identity;
    }

    public List<Organization> getAffiliations() {
        return this.affiliations;
    }

    public Integer getSequence() {
        return this.sequence;
    }

    public RoleType getRole() {
        return this.role;
    }

    public boolean isCorrespondingAuthor() {
        return this.correspondingAuthor;
    }

    @JacocoGenerated
    public int hashCode() {
        return Objects.hash(this.getIdentity(), this.getAffiliations(), this.getRole(), this.getSequence(), this.isCorrespondingAuthor());
    }

    @JacocoGenerated
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Contributor that = (Contributor)o;
        return this.isCorrespondingAuthor() == that.isCorrespondingAuthor() && Objects.equals(this.getIdentity(), that.getIdentity()) && Objects.equals(this.getAffiliations(), that.getAffiliations()) && Objects.equals(this.getRole(), that.getRole()) && Objects.equals(this.getSequence(), that.getSequence());
    }

    @Deprecated
    private static RoleType getRoleFromString(Object role) {
        return role instanceof String ? new RoleType(Role.parse(role.toString())) : (RoleType)role;
    }

    @Deprecated
    private static RoleType getType(Map<?, ?> role) {
        String tap = (String)role.get("type");
        Role type = Role.parse(tap);
        Optional<?> description = Optional.ofNullable(role.get("description"));
        RoleType roleType = new RoleType(type);
        return description.isEmpty() ? roleType : roleType.createOther((String)description.get());
    }

    @Deprecated
    private RoleType roleFromJson(Object role) {
        return role instanceof LinkedHashMap ? Contributor.getType((LinkedHashMap)role) : Contributor.getRoleFromString(role);
    }

    public Builder copy() {
        return new Builder().withAffiliations(this.getAffiliations()).withSequence(this.getSequence()).withCorrespondingAuthor(this.isCorrespondingAuthor()).withRole(this.getRole()).withIdentity(this.getIdentity());
    }

    public static final class Builder {
        private Identity identity;
        private List<Organization> affiliations;
        private Integer sequence;
        private RoleType role;
        private boolean correspondingAuthor;

        public Builder withIdentity(Identity identity) {
            this.identity = identity;
            return this;
        }

        public Builder withAffiliations(List<Organization> affiliations) {
            this.affiliations = affiliations;
            return this;
        }

        public Builder withRole(RoleType type) {
            this.role = type;
            return this;
        }

        public Builder withSequence(Integer sequence) {
            this.sequence = sequence;
            return this;
        }

        public Builder withCorrespondingAuthor(boolean correspondingAuthor) {
            this.correspondingAuthor = correspondingAuthor;
            return this;
        }

        public Contributor build() {
            return new Contributor(this);
        }
    }
}

