/*
 * Decompiled with CFR 0.152.
 */
package no.unit.nva.model.instancetypes.book;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.util.Objects;
import no.unit.nva.model.instancetypes.PublicationInstance;
import no.unit.nva.model.instancetypes.book.AcademicMonograph;
import no.unit.nva.model.instancetypes.book.BookMonographContentType;
import no.unit.nva.model.instancetypes.book.Encyclopedia;
import no.unit.nva.model.instancetypes.book.ExhibitionCatalog;
import no.unit.nva.model.instancetypes.book.NonFictionMonograph;
import no.unit.nva.model.instancetypes.book.PopularScienceMonograph;
import no.unit.nva.model.instancetypes.book.Textbook;
import no.unit.nva.model.pages.MonographPages;
import nva.commons.core.JacocoGenerated;

@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, property="type")
public class BookMonograph
implements PublicationInstance<MonographPages> {
    public static final String PAGES_FIELD = "pages";
    private static final String CONTENT_TYPE_FIELD = "contentType";
    private final MonographPages pages;

    public BookMonograph(@JsonProperty(value="pages") MonographPages pages) {
        this.pages = pages;
    }

    @JsonCreator
    public static BookMonograph fromJson(@JsonProperty(value="pages") MonographPages pages, @JsonProperty(value="contentType") BookMonographContentType contentType) {
        if (BookMonographContentType.ACADEMIC_MONOGRAPH.equals((Object)contentType)) {
            return new AcademicMonograph(pages);
        }
        if (BookMonographContentType.ENCYCLOPEDIA.equals((Object)contentType)) {
            return new Encyclopedia(pages);
        }
        if (BookMonographContentType.EXHIBITION_CATALOG.equals((Object)contentType)) {
            return new ExhibitionCatalog(pages);
        }
        if (BookMonographContentType.NON_FICTION_MONOGRAPH.equals((Object)contentType)) {
            return new NonFictionMonograph(pages);
        }
        if (BookMonographContentType.POPULAR_SCIENCE_MONOGRAPH.equals((Object)contentType)) {
            return new PopularScienceMonograph(pages);
        }
        if (BookMonographContentType.TEXTBOOK.equals((Object)contentType)) {
            return new Textbook(pages);
        }
        if (Objects.isNull((Object)contentType)) {
            return new AcademicMonograph(pages);
        }
        throw new UnsupportedOperationException("The Book Monograph subtype is unknown");
    }

    @Override
    public MonographPages getPages() {
        return this.pages;
    }

    @JacocoGenerated
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof BookMonograph)) {
            return false;
        }
        BookMonograph that = (BookMonograph)o;
        return Objects.equals(this.getPages(), that.getPages());
    }

    @JacocoGenerated
    public int hashCode() {
        return Objects.hash(this.getPages());
    }
}

