/*
 * Decompiled with CFR 0.152.
 */
package no.unit.nva.model.instancetypes.researchdata;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.net.URI;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import no.unit.nva.model.instancetypes.PublicationInstance;
import no.unit.nva.model.instancetypes.degree.ConfirmedDocument;
import no.unit.nva.model.instancetypes.degree.RelatedDocument;
import no.unit.nva.model.instancetypes.degree.UnconfirmedDocument;
import no.unit.nva.model.instancetypes.researchdata.CompliesWithUris;
import no.unit.nva.model.instancetypes.researchdata.GeographicalDescription;
import no.unit.nva.model.instancetypes.researchdata.ReferencedByUris;
import no.unit.nva.model.pages.NullPages;
import nva.commons.core.JacocoGenerated;
import nva.commons.core.attempt.Try;

@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, property="type")
public class DataSet
implements PublicationInstance<NullPages> {
    public static final String USER_AGREES_TO_TERMS_AND_CONDITIONS_FIELD = "userAgreesToTermsAndConditions";
    public static final String GEOGRAPHICAL_COVERAGE_FIELD = "geographicalCoverage";
    public static final String REFERENCED_BY_FIELD = "referencedBy";
    public static final String RELATED_FIELD = "related";
    public static final String COMPLIES_WITH_FIELD = "compliesWith";
    @JsonProperty(value="userAgreesToTermsAndConditions")
    private final boolean userAgreesToTermsAndConditions;
    @JsonProperty(value="geographicalCoverage")
    private final GeographicalDescription geographicalCoverage;
    @JsonProperty(value="referencedBy")
    private final Set<URI> referencedBy;
    @JsonProperty(value="related")
    private final Set<RelatedDocument> related;
    @JsonProperty(value="compliesWith")
    private final Set<URI> compliesWith;

    public DataSet(@JsonProperty(value="userAgreesToTermsAndConditions") boolean userAgreesToTermsAndConditions, @JsonProperty(value="geographicalCoverage") GeographicalDescription geographicalCoverage, @JsonProperty(value="referencedBy") ReferencedByUris referencedByUris, @JsonProperty(value="related") Set<Object> related, @JsonProperty(value="compliesWith") CompliesWithUris compliesWith) {
        this.geographicalCoverage = geographicalCoverage;
        this.referencedBy = Objects.nonNull(referencedByUris) ? new HashSet<URI>(referencedByUris) : Collections.emptySet();
        this.related = Objects.nonNull(related) ? related.stream().map(this::toRelatedDocument).collect(Collectors.toSet()) : Set.of();
        this.compliesWith = Objects.nonNull(compliesWith) ? new HashSet<URI>(compliesWith) : Collections.emptySet();
        this.userAgreesToTermsAndConditions = userAgreesToTermsAndConditions;
    }

    private RelatedDocument toRelatedDocument(Object item) {
        if (item instanceof Map) {
            Map map = (Map)item;
            String name = ConfirmedDocument.class.getSimpleName();
            return name.equals(map.get("type")) ? new ConfirmedDocument(URI.create(map.get("identifier").toString())) : new UnconfirmedDocument(map.get("identifier").toString());
        }
        URI value = (URI)Try.attempt(() -> URI.create(item.toString())).orElse(failure -> null);
        if (Objects.nonNull(value)) {
            return new ConfirmedDocument(value);
        }
        return new UnconfirmedDocument(item.toString());
    }

    public boolean isUserAgreesToTermsAndConditions() {
        return this.userAgreesToTermsAndConditions;
    }

    public GeographicalDescription getGeographicalCoverage() {
        return this.geographicalCoverage;
    }

    public Set<URI> getReferencedBy() {
        return this.referencedBy;
    }

    public Set<RelatedDocument> getRelated() {
        return this.related;
    }

    public Set<URI> getCompliesWith() {
        return this.compliesWith;
    }

    @Override
    public NullPages getPages() {
        return NullPages.NULL_PAGES;
    }

    @JacocoGenerated
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DataSet)) {
            return false;
        }
        DataSet dataSet = (DataSet)o;
        return this.isUserAgreesToTermsAndConditions() == dataSet.isUserAgreesToTermsAndConditions() && Objects.equals(this.getGeographicalCoverage(), dataSet.getGeographicalCoverage()) && Objects.equals(this.getReferencedBy(), dataSet.getReferencedBy()) && Objects.equals(this.getRelated(), dataSet.getRelated()) && Objects.equals(this.getCompliesWith(), dataSet.getCompliesWith());
    }

    @JacocoGenerated
    public int hashCode() {
        return Objects.hash(this.isUserAgreesToTermsAndConditions(), this.getGeographicalCoverage(), this.getReferencedBy(), this.getRelated(), this.getCompliesWith());
    }
}

