/*
 * Decompiled with CFR 0.152.
 */
package no.unit.nva.model.associatedartifacts;

import com.fasterxml.jackson.annotation.JsonCreator;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Objects;
import no.unit.nva.model.associatedartifacts.AssociatedArtifact;
import no.unit.nva.model.associatedartifacts.InvalidAssociatedArtifactsException;
import no.unit.nva.model.associatedartifacts.NullAssociatedArtifact;
import no.unit.nva.model.associatedartifacts.file.AdministrativeAgreement;
import nva.commons.core.JacocoGenerated;

public class AssociatedArtifactList
implements List<AssociatedArtifact> {
    public static final String NULL_OBJECT_MUST_BE_SINGLETON_IN_LIST = "AssociatedArtifactLists containing NullAssociatedArtifact must contain only this element as a singleton";
    private final List<AssociatedArtifact> associatedArtifacts;

    @JsonCreator
    public AssociatedArtifactList(List<AssociatedArtifact> artifacts) {
        this.throwExceptionIfNullObjectIsNotOnlyElementInList(artifacts);
        this.associatedArtifacts = Objects.nonNull(artifacts) ? artifacts : Collections.emptyList();
    }

    public AssociatedArtifactList(AssociatedArtifact ... artifacts) {
        this(Arrays.asList(artifacts));
    }

    public static AssociatedArtifactList empty() {
        return new AssociatedArtifactList(Collections.emptyList());
    }

    @Override
    public int size() {
        return this.associatedArtifacts.size();
    }

    @Override
    public boolean isEmpty() {
        return this.associatedArtifacts.isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        return this.associatedArtifacts.contains(o);
    }

    @Override
    public Iterator<AssociatedArtifact> iterator() {
        return this.associatedArtifacts.iterator();
    }

    @Override
    public Object[] toArray() {
        return this.associatedArtifacts.toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return this.associatedArtifacts.toArray(a);
    }

    @Override
    public boolean add(AssociatedArtifact associatedArtifact) {
        return this.associatedArtifacts.add(associatedArtifact);
    }

    @Override
    public void add(int index, AssociatedArtifact element) {
        this.associatedArtifacts.add(index, element);
    }

    @Override
    public boolean remove(Object o) {
        return this.associatedArtifacts.remove(o);
    }

    @Override
    public AssociatedArtifact remove(int index) {
        return this.associatedArtifacts.remove(index);
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this.associatedArtifacts.containsAll(c);
    }

    @Override
    public boolean addAll(Collection<? extends AssociatedArtifact> c) {
        return this.associatedArtifacts.addAll(c);
    }

    @Override
    public boolean addAll(int index, Collection<? extends AssociatedArtifact> c) {
        return this.associatedArtifacts.addAll(index, c);
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        return this.associatedArtifacts.removeAll(c);
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        return this.associatedArtifacts.retainAll(c);
    }

    @Override
    public void clear() {
        this.associatedArtifacts.clear();
    }

    @Override
    @JacocoGenerated
    public boolean equals(Object o) {
        return this.associatedArtifacts.equals(o);
    }

    @Override
    @JacocoGenerated
    public int hashCode() {
        return Objects.hash(this.associatedArtifacts);
    }

    @Override
    public AssociatedArtifact get(int index) {
        return this.associatedArtifacts.get(index);
    }

    @Override
    public AssociatedArtifact set(int index, AssociatedArtifact element) {
        return this.associatedArtifacts.set(index, element);
    }

    @Override
    public int indexOf(Object o) {
        return this.associatedArtifacts.indexOf(o);
    }

    @Override
    public int lastIndexOf(Object o) {
        return this.associatedArtifacts.lastIndexOf(o);
    }

    @Override
    public ListIterator<AssociatedArtifact> listIterator() {
        return this.associatedArtifacts.listIterator();
    }

    @Override
    public ListIterator<AssociatedArtifact> listIterator(int index) {
        return this.associatedArtifacts.listIterator(index);
    }

    @Override
    public List<AssociatedArtifact> subList(int fromIndex, int toIndex) {
        return this.associatedArtifacts.subList(fromIndex, toIndex);
    }

    public boolean isPublishable() {
        return !this.isEmpty() && this.associatedArtifactsAreNotOnlyAdministrativeAgreements();
    }

    private void throwExceptionIfNullObjectIsNotOnlyElementInList(List<AssociatedArtifact> artifacts) {
        if (Objects.nonNull(artifacts) && this.containsNullObject(artifacts) && artifacts.size() > 1) {
            throw new InvalidAssociatedArtifactsException(NULL_OBJECT_MUST_BE_SINGLETON_IN_LIST);
        }
    }

    private boolean containsNullObject(List<AssociatedArtifact> artifacts) {
        return artifacts.stream().anyMatch(NullAssociatedArtifact.class::isInstance);
    }

    private boolean associatedArtifactsAreNotOnlyAdministrativeAgreements() {
        return this.associatedArtifacts.stream().anyMatch(item -> !(item instanceof AdministrativeAgreement));
    }
}

