/*
 * Decompiled with CFR 0.152.
 */
package no.unit.nva.model.associatedartifacts.file;

import com.fasterxml.jackson.annotation.JsonAlias;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.time.Instant;
import java.util.UUID;
import no.unit.nva.model.associatedartifacts.RightsRetentionStrategy;
import no.unit.nva.model.associatedartifacts.file.File;
import no.unit.nva.model.associatedartifacts.file.UploadDetails;

@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, property="type")
@JsonTypeName(value="UnpublishedFile")
public class UnpublishedFile
extends File {
    public static final String TYPE = "UnpublishedFile";

    @JsonCreator
    public UnpublishedFile(@JsonProperty(value="identifier") UUID identifier, @JsonProperty(value="name") String name, @JsonProperty(value="mimeType") String mimeType, @JsonProperty(value="size") Long size, @JsonProperty(value="license") Object license, @JsonProperty(value="administrativeAgreement") boolean administrativeAgreement, @JsonProperty(value="publisherVersion") @JsonAlias(value={"publisherAuthority"}) Object publishedVersion, @JsonProperty(value="embargoDate") Instant embargoDate, @JsonProperty(value="rightsRetentionStrategy") RightsRetentionStrategy rightsRetentionStrategy, @JsonProperty(value="legalNote") String legalNote, @JsonProperty(value="uploadDetails") UploadDetails uploadDetails) {
        super(identifier, name, mimeType, size, license, administrativeAgreement, publishedVersion, embargoDate, rightsRetentionStrategy, legalNote, null, uploadDetails);
        if (administrativeAgreement) {
            throw new IllegalStateException("An administrative agreement is not publishable");
        }
    }

    @Override
    public boolean isVisibleForNonOwner() {
        return false;
    }

    @Override
    public UnpublishedFile toUnpublishedFile() {
        return this;
    }

    @Override
    public File.Builder copy() {
        return UnpublishedFile.builder().withIdentifier(this.getIdentifier()).withName(this.getName()).withMimeType(this.getMimeType()).withSize(this.getSize()).withLicense(this.getLicense()).withAdministrativeAgreement(this.isAdministrativeAgreement()).withPublisherVersion(this.getPublisherVersion()).withEmbargoDate(this.getEmbargoDate().orElse(null)).withRightsRetentionStrategy(this.getRightsRetentionStrategy()).withLegalNote(this.getLegalNote()).withUploadDetails(this.getUploadDetails());
    }
}

