/*
 * Decompiled with CFR 0.152.
 */
package no.unit.nva.model.instancetypes.artistic.music;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import no.unit.nva.model.contexttypes.PublishingHouse;
import no.unit.nva.model.contexttypes.UnconfirmedPublisher;
import no.unit.nva.model.instancetypes.artistic.UnconfirmedPublisherMigrator;
import no.unit.nva.model.instancetypes.artistic.music.Isrc;
import no.unit.nva.model.instancetypes.artistic.music.MusicMediaSubtype;
import no.unit.nva.model.instancetypes.artistic.music.MusicMediaType;
import no.unit.nva.model.instancetypes.artistic.music.MusicPerformanceManifestation;
import no.unit.nva.model.instancetypes.artistic.music.MusicTrack;
import no.unit.nva.model.util.SerializationUtils;
import nva.commons.core.JacocoGenerated;

@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, property="type")
public class AudioVisualPublication
implements MusicPerformanceManifestation,
UnconfirmedPublisherMigrator {
    public static final String MEDIA_TYPE_FIELD = "mediaType";
    public static final String PUBLISHER_FIELD = "publisher";
    public static final String CATALOGUE_NUMBER_FIELD = "catalogueNumber";
    public static final String TRACK_LIST_FIELD = "trackList";
    public static final String ISRC_FIELD = "isrc";
    @JsonProperty(value="mediaType")
    private final MusicMediaSubtype mediaType;
    @JsonProperty(value="publisher")
    private final PublishingHouse publisher;
    @JsonProperty(value="catalogueNumber")
    private final String catalogueNumber;
    @JsonProperty(value="trackList")
    private final List<MusicTrack> trackList;
    @JsonProperty(value="isrc")
    private final Isrc isrc;

    public AudioVisualPublication(@JsonProperty(value="mediaType") MusicMediaSubtype type, @JsonProperty(value="publisher") PublishingHouse publisher, @JsonProperty(value="catalogueNumber") String catalogueNumber, @JsonProperty(value="trackList") List<MusicTrack> trackList, @JsonProperty(value="isrc") Isrc isrc) {
        this.mediaType = type;
        this.publisher = publisher;
        this.catalogueNumber = catalogueNumber;
        this.trackList = SerializationUtils.nullListAsEmpty(trackList);
        this.isrc = isrc;
    }

    @Deprecated
    @JsonCreator
    public static AudioVisualPublication fromJson(@JsonProperty(value="mediaType") Object mediaType, @JsonProperty(value="publisher") Object publisher, @JsonProperty(value="catalogueNumber") String catalogueNumber, @JsonProperty(value="trackList") List<MusicTrack> trackList, @JsonProperty(value="isrc") Isrc isrc) {
        PublishingHouse publishingHouse = publisher instanceof String ? new UnconfirmedPublisher((String)publisher) : UnconfirmedPublisherMigrator.toPublisher(publisher);
        MusicMediaSubtype mediaSubType = AudioVisualPublication.mapMediaType(mediaType);
        return new AudioVisualPublication(mediaSubType, publishingHouse, catalogueNumber, trackList, isrc);
    }

    public Isrc getIsrc() {
        return this.isrc;
    }

    public MusicMediaSubtype getMediaType() {
        return this.mediaType;
    }

    public PublishingHouse getPublisher() {
        return this.publisher;
    }

    public String getCatalogueNumber() {
        return this.catalogueNumber;
    }

    public List<MusicTrack> getTrackList() {
        return this.trackList;
    }

    @JacocoGenerated
    public int hashCode() {
        return Objects.hash(this.getMediaType(), this.getPublisher(), this.getCatalogueNumber(), this.getTrackList(), this.getIsrc());
    }

    @JacocoGenerated
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AudioVisualPublication that = (AudioVisualPublication)o;
        return Objects.equals(this.getMediaType(), that.getMediaType()) && Objects.equals(this.getPublisher(), that.getPublisher()) && Objects.equals(this.getCatalogueNumber(), that.getCatalogueNumber()) && Objects.equals(this.getTrackList(), that.getTrackList()) && Objects.equals(this.getIsrc(), that.getIsrc());
    }

    @Deprecated
    private static MusicMediaSubtype mapMediaType(Object mediaType) {
        return mediaType instanceof Map ? AudioVisualPublication.mapFromObject((Map)mediaType) : new MusicMediaSubtype(MusicMediaType.parse((String)mediaType));
    }

    @Deprecated
    private static MusicMediaSubtype mapFromObject(Map<?, ?> map) {
        String type = (String)map.get("type");
        MusicMediaType mediaType = MusicMediaType.parse(type);
        Optional<?> description = Optional.ofNullable(map.get("description"));
        MusicMediaSubtype mediaSubtype = new MusicMediaSubtype(mediaType);
        return description.map(subType -> MusicMediaSubtype.createOther((String)subType)).orElse(mediaSubtype);
    }
}

