/*
 * Decompiled with CFR 0.152.
 */
package no.unit.nva.model;

import java.time.Year;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.IntSupplier;
import no.unit.nva.model.EntityDescription;
import no.unit.nva.model.Publication;
import no.unit.nva.model.PublicationDate;
import no.unit.nva.model.PublicationStatus;
import no.unit.nva.model.Reference;
import no.unit.nva.model.instancetypes.PublicationInstance;
import nva.commons.core.JacocoGenerated;
import nva.commons.core.StringUtils;
import nva.commons.core.attempt.Try;

final class FindableDoiRequirementsValidator {
    private static final Set<PublicationStatus> VALID_PUBLICATION_STATUS_FOR_FINDABLE_DOI = Set.of(PublicationStatus.PUBLISHED, PublicationStatus.PUBLISHED_METADATA);
    public static final int PUBLISH_YEAR_MIN = 1000;
    public static final int YEARS_AHEAD_ASSUMED_FROM_DOCS = 4;
    public static final IntSupplier PUBLISH_YEAR_MAX = () -> Year.now().getValue() + 4;

    @JacocoGenerated
    private FindableDoiRequirementsValidator() {
    }

    static boolean meetsFindableDoiRequirements(Publication publication) {
        return FindableDoiRequirementsValidator.hasCorrectPublishedStatus(publication) && FindableDoiRequirementsValidator.mandatoryFieldsAreNotNull(publication) && FindableDoiRequirementsValidator.hasValidPublishedYear(publication);
    }

    private static boolean hasValidPublishedYear(Publication publication) {
        String yearString = publication.getEntityDescription().getPublicationDate().getYear();
        Integer year = Try.attempt(() -> Integer.parseInt(yearString)).toOptional().orElse(null);
        return Objects.nonNull(year) && year >= 1000 && year <= PUBLISH_YEAR_MAX.getAsInt();
    }

    private static boolean hasCorrectPublishedStatus(Publication publication) {
        return VALID_PUBLICATION_STATUS_FOR_FINDABLE_DOI.contains((Object)publication.getStatus());
    }

    private static boolean mandatoryFieldsAreNotNull(Publication publication) {
        return Objects.nonNull(publication.getIdentifier()) && Objects.nonNull(publication.getPublisher()) && Objects.nonNull(publication.getPublisher().getId()) && Objects.nonNull(publication.getModifiedDate()) && FindableDoiRequirementsValidator.hasAMainTitle(publication) && FindableDoiRequirementsValidator.hasAnInstanceType(publication) && FindableDoiRequirementsValidator.hasPublicationYear(publication);
    }

    private static boolean hasPublicationYear(Publication publication) {
        return Optional.ofNullable(publication.getEntityDescription()).map(EntityDescription::getPublicationDate).map(PublicationDate::getYear).isPresent();
    }

    private static boolean hasAnInstanceType(Publication publication) {
        return Optional.ofNullable(publication.getEntityDescription()).map(EntityDescription::getReference).map(Reference::getPublicationInstance).map(PublicationInstance::getInstanceType).isPresent();
    }

    private static boolean hasAMainTitle(Publication publication) {
        return Optional.ofNullable(publication.getEntityDescription()).map(EntityDescription::getMainTitle).map(StringUtils::isNotEmpty).orElse(false);
    }
}

