/*
 * Decompiled with CFR 0.152.
 */
package no.unit.nva.model.time.duration;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.util.Objects;
import no.unit.nva.model.time.duration.Duration;
import nva.commons.core.JacocoGenerated;

@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, property="type")
public final class DefinedDuration
implements Duration {
    public static final String MINUTES_FIELD = "minutes";
    public static final String HOURS_FIELD = "hours";
    public static final String DAYS_FIELD = "days";
    public static final String WEEKS_FIELD = "weeks";
    private final int minutes;
    private final int hours;
    private final int days;
    private final int weeks;

    @JsonCreator
    private DefinedDuration(@JsonProperty(value="minutes") int minutes, @JsonProperty(value="hours") int hours, @JsonProperty(value="days") int days, @JsonProperty(value="weeks") int weeks) {
        this.minutes = minutes;
        this.hours = hours;
        this.days = days;
        this.weeks = weeks;
    }

    public static Builder builder() {
        return new Builder();
    }

    public int getMinutes() {
        return this.minutes;
    }

    public int getHours() {
        return this.hours;
    }

    @JacocoGenerated
    public int hashCode() {
        return Objects.hash(this.minutes, this.hours, this.days, this.weeks);
    }

    @JacocoGenerated
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DefinedDuration)) {
            return false;
        }
        DefinedDuration that = (DefinedDuration)o;
        return Objects.equals(this.minutes, that.minutes) && Objects.equals(this.hours, that.hours) && Objects.equals(this.days, that.days) && Objects.equals(this.weeks, that.weeks);
    }

    public int getDays() {
        return this.days;
    }

    public int getWeeks() {
        return this.weeks;
    }

    public static final class Builder {
        private int minutes;
        private int hours;
        private int days;
        private int weeks;

        private Builder() {
        }

        public Builder withMinutes(int minutes) {
            this.minutes = minutes;
            return this;
        }

        public Builder withHours(int hours) {
            this.hours = hours;
            return this;
        }

        public Builder withDays(int days) {
            this.days = days;
            return this;
        }

        public Builder withWeeks(int weeks) {
            this.weeks = weeks;
            return this;
        }

        public DefinedDuration build() {
            return new DefinedDuration(this.minutes, this.hours, this.days, this.weeks);
        }
    }
}

