/*
 * Decompiled with CFR 0.152.
 */
package me.chanjar.weixin.common.util.http;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import me.chanjar.weixin.common.bean.result.WxError;
import me.chanjar.weixin.common.exception.WxErrorException;
import me.chanjar.weixin.common.util.StringUtils;
import me.chanjar.weixin.common.util.fs.FileUtils;
import me.chanjar.weixin.common.util.http.InputStreamResponseHandler;
import me.chanjar.weixin.common.util.http.RequestExecutor;
import me.chanjar.weixin.common.util.http.Utf8ResponseHandler;
import org.apache.http.Header;
import org.apache.http.HttpHost;
import org.apache.http.HttpResponse;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.impl.client.CloseableHttpClient;

public class MediaDownloadRequestExecutor
implements RequestExecutor<File, String> {
    private File tmpDirFile;

    public MediaDownloadRequestExecutor() {
    }

    public MediaDownloadRequestExecutor(File tmpDirFile) {
        this.tmpDirFile = tmpDirFile;
    }

    /*
     * Loose catch block
     */
    @Override
    public File execute(CloseableHttpClient httpclient, HttpHost httpProxy, String uri, String queryParam) throws WxErrorException, ClientProtocolException, IOException {
        if (queryParam != null) {
            if (uri.indexOf(63) == -1) {
                uri = uri + '?';
            }
            uri = uri + (uri.endsWith("?") ? queryParam : '&' + queryParam);
        }
        HttpGet httpGet = new HttpGet(uri);
        if (httpProxy != null) {
            RequestConfig config = RequestConfig.custom().setProxy(httpProxy).build();
            httpGet.setConfig(config);
        }
        try {
            File file;
            try (CloseableHttpResponse response = httpclient.execute((HttpUriRequest)httpGet);){
                File localFile;
                Header[] contentTypeHeader = response.getHeaders("Content-Type");
                if (contentTypeHeader != null && contentTypeHeader.length > 0 && ContentType.TEXT_PLAIN.getMimeType().equals(contentTypeHeader[0].getValue())) {
                    String responseContent = (String)Utf8ResponseHandler.INSTANCE.handleResponse((HttpResponse)response);
                    throw new WxErrorException(WxError.fromJson(responseContent));
                }
                InputStream inputStream = (InputStream)InputStreamResponseHandler.INSTANCE.handleResponse((HttpResponse)response);
                String fileName = this.getFileName(response);
                if (StringUtils.isBlank(fileName)) {
                    File file2 = null;
                    return file2;
                }
                String[] name_ext = fileName.split("\\.");
                file = localFile = FileUtils.createTmpFile(inputStream, name_ext[0], name_ext[1], this.tmpDirFile);
            }
            return file;
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            httpGet.releaseConnection();
        }
    }

    protected String getFileName(CloseableHttpResponse response) {
        Header[] contentDispositionHeader = response.getHeaders("Content-disposition");
        Pattern p = Pattern.compile(".*filename=\"(.*)\"");
        Matcher m = p.matcher(contentDispositionHeader[0].getValue());
        m.matches();
        String fileName = m.group(1);
        return fileName;
    }
}

