/*
 * Decompiled with CFR 0.152.
 */
package me.chanjar.weixin.common.util.http.okhttp;

import java.io.File;
import java.io.IOException;
import me.chanjar.weixin.common.bean.result.WxError;
import me.chanjar.weixin.common.bean.result.WxMediaUploadResult;
import me.chanjar.weixin.common.exception.WxErrorException;
import me.chanjar.weixin.common.util.http.MediaUploadRequestExecutor;
import me.chanjar.weixin.common.util.http.RequestHttp;
import me.chanjar.weixin.common.util.http.okhttp.OkHttpProxyInfo;
import okhttp3.Authenticator;
import okhttp3.ConnectionPool;
import okhttp3.Credentials;
import okhttp3.MediaType;
import okhttp3.MultipartBody;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.Route;

public class OkHttpMediaUploadRequestExecutor
extends MediaUploadRequestExecutor<ConnectionPool, OkHttpProxyInfo> {
    public OkHttpMediaUploadRequestExecutor(RequestHttp requestHttp) {
        super(requestHttp);
    }

    @Override
    public WxMediaUploadResult execute(String uri, File file) throws WxErrorException, IOException {
        OkHttpClient.Builder clientBuilder = new OkHttpClient.Builder().connectionPool((ConnectionPool)this.requestHttp.getRequestHttpClient());
        if (this.requestHttp.getRequestHttpProxy() != null) {
            clientBuilder.proxy(((OkHttpProxyInfo)this.requestHttp.getRequestHttpProxy()).getProxy());
        }
        clientBuilder.authenticator(new Authenticator(){

            public Request authenticate(Route route, Response response) throws IOException {
                String credential = Credentials.basic((String)((OkHttpProxyInfo)OkHttpMediaUploadRequestExecutor.this.requestHttp.getRequestHttpProxy()).getProxyUsername(), (String)((OkHttpProxyInfo)OkHttpMediaUploadRequestExecutor.this.requestHttp.getRequestHttpProxy()).getProxyPassword());
                return response.request().newBuilder().header("Authorization", credential).build();
            }
        });
        OkHttpClient client = clientBuilder.build();
        MultipartBody body = new MultipartBody.Builder().setType(MediaType.parse((String)"multipart/form-data")).addFormDataPart("media", file.getName(), RequestBody.create((MediaType)MediaType.parse((String)"application/octet-stream"), (File)file)).build();
        Request request = new Request.Builder().url(uri).post((RequestBody)body).build();
        Response response = client.newCall(request).execute();
        String responseContent = response.body().string();
        WxError error = WxError.fromJson(responseContent);
        if (error.getErrorCode() != 0) {
            throw new WxErrorException(error);
        }
        return WxMediaUploadResult.fromJson(responseContent);
    }
}

