/*
 * Decompiled with CFR 0.152.
 */
package me.chanjar.weixin.cp.api;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.regex.Pattern;
import me.chanjar.weixin.common.api.WxErrorExceptionHandler;
import me.chanjar.weixin.common.exception.WxErrorException;
import me.chanjar.weixin.common.session.WxSessionManager;
import me.chanjar.weixin.cp.api.WxCpMessageHandler;
import me.chanjar.weixin.cp.api.WxCpMessageInterceptor;
import me.chanjar.weixin.cp.api.WxCpMessageMatcher;
import me.chanjar.weixin.cp.api.WxCpMessageRouter;
import me.chanjar.weixin.cp.api.WxCpService;
import me.chanjar.weixin.cp.bean.WxCpXmlMessage;
import me.chanjar.weixin.cp.bean.WxCpXmlOutMessage;

public class WxCpMessageRouterRule {
    private final WxCpMessageRouter routerBuilder;
    private boolean async = true;
    private String fromUser;
    private String msgType;
    private String event;
    private String eventKey;
    private String content;
    private String rContent;
    private WxCpMessageMatcher matcher;
    private boolean reEnter = false;
    private Integer agentId;
    private List<WxCpMessageHandler> handlers = new ArrayList<WxCpMessageHandler>();
    private List<WxCpMessageInterceptor> interceptors = new ArrayList<WxCpMessageInterceptor>();

    protected WxCpMessageRouterRule(WxCpMessageRouter routerBuilder) {
        this.routerBuilder = routerBuilder;
    }

    public WxCpMessageRouterRule async(boolean async) {
        this.async = async;
        return this;
    }

    public WxCpMessageRouterRule agentId(Integer agentId) {
        this.agentId = agentId;
        return this;
    }

    public WxCpMessageRouterRule msgType(String msgType) {
        this.msgType = msgType;
        return this;
    }

    public WxCpMessageRouterRule event(String event) {
        this.event = event;
        return this;
    }

    public WxCpMessageRouterRule eventKey(String eventKey) {
        this.eventKey = eventKey;
        return this;
    }

    public WxCpMessageRouterRule content(String content) {
        this.content = content;
        return this;
    }

    public WxCpMessageRouterRule rContent(String regex) {
        this.rContent = regex;
        return this;
    }

    public WxCpMessageRouterRule fromUser(String fromUser) {
        this.fromUser = fromUser;
        return this;
    }

    public WxCpMessageRouterRule matcher(WxCpMessageMatcher matcher) {
        this.matcher = matcher;
        return this;
    }

    public WxCpMessageRouterRule interceptor(WxCpMessageInterceptor interceptor) {
        return this.interceptor(interceptor, null);
    }

    public WxCpMessageRouterRule interceptor(WxCpMessageInterceptor interceptor, WxCpMessageInterceptor ... otherInterceptors) {
        this.interceptors.add(interceptor);
        if (otherInterceptors != null && otherInterceptors.length > 0) {
            for (WxCpMessageInterceptor i : otherInterceptors) {
                this.interceptors.add(i);
            }
        }
        return this;
    }

    public WxCpMessageRouterRule handler(WxCpMessageHandler handler) {
        return this.handler(handler, null);
    }

    public WxCpMessageRouterRule handler(WxCpMessageHandler handler, WxCpMessageHandler ... otherHandlers) {
        this.handlers.add(handler);
        if (otherHandlers != null && otherHandlers.length > 0) {
            for (WxCpMessageHandler i : otherHandlers) {
                this.handlers.add(i);
            }
        }
        return this;
    }

    public WxCpMessageRouter end() {
        this.routerBuilder.getRules().add(this);
        return this.routerBuilder;
    }

    public WxCpMessageRouter next() {
        this.reEnter = true;
        return this.end();
    }

    protected boolean test(WxCpXmlMessage wxMessage) {
        return !(this.fromUser != null && !this.fromUser.equals(wxMessage.getFromUserName()) || this.agentId != null && !this.agentId.equals(wxMessage.getAgentId()) || this.msgType != null && !this.msgType.equals(wxMessage.getMsgType()) || this.event != null && !this.event.equals(wxMessage.getEvent()) || this.eventKey != null && !this.eventKey.equals(wxMessage.getEventKey()) || this.content != null && !this.content.equals(wxMessage.getContent() == null ? null : wxMessage.getContent().trim()) || this.rContent != null && !Pattern.matches(this.rContent, wxMessage.getContent() == null ? "" : wxMessage.getContent().trim()) || this.matcher != null && !this.matcher.match(wxMessage));
    }

    protected WxCpXmlOutMessage service(WxCpXmlMessage wxMessage, WxCpService wxCpService, WxSessionManager sessionManager, WxErrorExceptionHandler exceptionHandler) {
        try {
            HashMap<String, Object> context = new HashMap<String, Object>();
            for (WxCpMessageInterceptor interceptor : this.interceptors) {
                if (interceptor.intercept(wxMessage, context, wxCpService, sessionManager)) continue;
                return null;
            }
            WxCpXmlOutMessage res = null;
            for (WxCpMessageHandler handler : this.handlers) {
                res = handler.handle(wxMessage, context, wxCpService, sessionManager);
            }
            return res;
        }
        catch (WxErrorException e) {
            exceptionHandler.handle(e);
            return null;
        }
    }

    public void setFromUser(String fromUser) {
        this.fromUser = fromUser;
    }

    public void setMsgType(String msgType) {
        this.msgType = msgType;
    }

    public void setEvent(String event) {
        this.event = event;
    }

    public void setEventKey(String eventKey) {
        this.eventKey = eventKey;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public void setrContent(String rContent) {
        this.rContent = rContent;
    }

    public void setMatcher(WxCpMessageMatcher matcher) {
        this.matcher = matcher;
    }

    public void setAgentId(Integer agentId) {
        this.agentId = agentId;
    }

    public void setHandlers(List<WxCpMessageHandler> handlers) {
        this.handlers = handlers;
    }

    public void setInterceptors(List<WxCpMessageInterceptor> interceptors) {
        this.interceptors = interceptors;
    }

    public boolean isAsync() {
        return this.async;
    }

    public void setAsync(boolean async) {
        this.async = async;
    }

    public boolean isReEnter() {
        return this.reEnter;
    }

    public void setReEnter(boolean reEnter) {
        this.reEnter = reEnter;
    }
}

