/*
 * Decompiled with CFR 0.152.
 */
package me.chanjar.weixin.cp.util.json;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;
import me.chanjar.weixin.cp.bean.WxCpMessage;
import me.chanjar.weixin.cp.bean.article.MpnewsArticle;
import me.chanjar.weixin.cp.bean.article.NewArticle;
import org.apache.commons.lang3.StringUtils;

public class WxCpMessageGsonAdapter
implements JsonSerializer<WxCpMessage> {
    public JsonElement serialize(WxCpMessage message, Type typeOfSrc, JsonSerializationContext context) {
        JsonObject articleJson;
        JsonArray articleJsonArray;
        JsonObject newsJsonObject;
        JsonObject image;
        JsonObject messageJson = new JsonObject();
        messageJson.addProperty("agentid", (Number)message.getAgentId());
        if (StringUtils.isNotBlank((CharSequence)message.getToUser())) {
            messageJson.addProperty("touser", message.getToUser());
        }
        messageJson.addProperty("msgtype", message.getMsgType());
        if (StringUtils.isNotBlank((CharSequence)message.getToParty())) {
            messageJson.addProperty("toparty", message.getToParty());
        }
        if (StringUtils.isNotBlank((CharSequence)message.getToTag())) {
            messageJson.addProperty("totag", message.getToTag());
        }
        if ("text".equals(message.getMsgType())) {
            JsonObject text = new JsonObject();
            text.addProperty("content", message.getContent());
            messageJson.add("text", (JsonElement)text);
        }
        if ("image".equals(message.getMsgType())) {
            image = new JsonObject();
            image.addProperty("media_id", message.getMediaId());
            messageJson.add("image", (JsonElement)image);
        }
        if ("file".equals(message.getMsgType())) {
            image = new JsonObject();
            image.addProperty("media_id", message.getMediaId());
            messageJson.add("file", (JsonElement)image);
        }
        if ("voice".equals(message.getMsgType())) {
            JsonObject voice = new JsonObject();
            voice.addProperty("media_id", message.getMediaId());
            messageJson.add("voice", (JsonElement)voice);
        }
        if (StringUtils.isNotBlank((CharSequence)message.getSafe())) {
            messageJson.addProperty("safe", message.getSafe());
        }
        if ("video".equals(message.getMsgType())) {
            JsonObject video = new JsonObject();
            video.addProperty("media_id", message.getMediaId());
            video.addProperty("thumb_media_id", message.getThumbMediaId());
            video.addProperty("title", message.getTitle());
            video.addProperty("description", message.getDescription());
            messageJson.add("video", (JsonElement)video);
        }
        if ("news".equals(message.getMsgType())) {
            newsJsonObject = new JsonObject();
            articleJsonArray = new JsonArray();
            for (NewArticle newArticle : message.getArticles()) {
                articleJson = new JsonObject();
                articleJson.addProperty("title", newArticle.getTitle());
                articleJson.addProperty("description", newArticle.getDescription());
                articleJson.addProperty("url", newArticle.getUrl());
                articleJson.addProperty("picurl", newArticle.getPicUrl());
                articleJsonArray.add((JsonElement)articleJson);
            }
            newsJsonObject.add("articles", (JsonElement)articleJsonArray);
            messageJson.add("news", (JsonElement)newsJsonObject);
        }
        if ("mpnews".equals(message.getMsgType())) {
            newsJsonObject = new JsonObject();
            if (message.getMediaId() != null) {
                newsJsonObject.addProperty("media_id", message.getMediaId());
            } else {
                articleJsonArray = new JsonArray();
                for (MpnewsArticle mpnewsArticle : message.getMpnewsArticles()) {
                    articleJson = new JsonObject();
                    articleJson.addProperty("title", mpnewsArticle.getTitle());
                    articleJson.addProperty("thumb_media_id", mpnewsArticle.getThumbMediaId());
                    articleJson.addProperty("author", mpnewsArticle.getAuthor());
                    articleJson.addProperty("content_source_url", mpnewsArticle.getContentSourceUrl());
                    articleJson.addProperty("content", mpnewsArticle.getContent());
                    articleJson.addProperty("digest", mpnewsArticle.getDigest());
                    articleJson.addProperty("show_cover_pic", mpnewsArticle.getShowCoverPic());
                    articleJsonArray.add((JsonElement)articleJson);
                }
                newsJsonObject.add("articles", (JsonElement)articleJsonArray);
            }
            messageJson.add("mpnews", (JsonElement)newsJsonObject);
        }
        return messageJson;
    }
}

