/*
 * Decompiled with CFR 0.152.
 */
package me.chanjar.weixin.cp.api.impl;

import java.io.IOException;
import me.chanjar.weixin.common.bean.WxAccessToken;
import me.chanjar.weixin.common.bean.result.WxError;
import me.chanjar.weixin.common.exception.WxErrorException;
import me.chanjar.weixin.common.util.http.HttpType;
import me.chanjar.weixin.common.util.http.okhttp.OkHttpProxyInfo;
import me.chanjar.weixin.cp.api.impl.AbstractWxCpServiceImpl;
import me.chanjar.weixin.cp.config.WxCpConfigStorage;
import okhttp3.Authenticator;
import okhttp3.ConnectionPool;
import okhttp3.Credentials;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.Route;

public class WxCpServiceOkHttpImpl
extends AbstractWxCpServiceImpl<ConnectionPool, OkHttpProxyInfo> {
    protected ConnectionPool httpClient;
    protected OkHttpProxyInfo httpProxy;

    public ConnectionPool getRequestHttpClient() {
        return this.httpClient;
    }

    public OkHttpProxyInfo getRequestHttpProxy() {
        return this.httpProxy;
    }

    public HttpType getRequestType() {
        return HttpType.OK_HTTP;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getAccessToken(boolean forceRefresh) throws WxErrorException {
        if (forceRefresh) {
            this.configStorage.expireAccessToken();
        }
        if (this.configStorage.isAccessTokenExpired()) {
            Object object = this.globalAccessTokenRefreshLock;
            synchronized (object) {
                if (this.configStorage.isAccessTokenExpired()) {
                    String url = "https://qyapi.weixin.qq.com/cgi-bin/gettoken?&corpid=" + this.configStorage.getCorpId() + "&corpsecret=" + this.configStorage.getCorpSecret();
                    OkHttpClient.Builder clientBuilder = new OkHttpClient.Builder().connectionPool(this.httpClient);
                    if (this.httpProxy != null) {
                        clientBuilder.proxy(this.getRequestHttpProxy().getProxy());
                    }
                    clientBuilder.authenticator(new Authenticator(){

                        public Request authenticate(Route route, Response response) throws IOException {
                            String credential = Credentials.basic((String)WxCpServiceOkHttpImpl.this.httpProxy.getProxyUsername(), (String)WxCpServiceOkHttpImpl.this.httpProxy.getProxyPassword());
                            return response.request().newBuilder().header("Authorization", credential).build();
                        }
                    });
                    OkHttpClient client = clientBuilder.build();
                    Request request = new Request.Builder().url(url).get().build();
                    Response response = null;
                    try {
                        response = client.newCall(request).execute();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                    String resultContent = null;
                    try {
                        resultContent = response.body().string();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                    WxError error = WxError.fromJson((String)resultContent);
                    if (error.getErrorCode() != 0) {
                        throw new WxErrorException(error);
                    }
                    WxAccessToken accessToken = WxAccessToken.fromJson((String)resultContent);
                    this.configStorage.updateAccessToken(accessToken.getAccessToken(), accessToken.getExpiresIn());
                }
            }
        }
        return this.configStorage.getAccessToken();
    }

    @Override
    public void initHttp() {
        WxCpConfigStorage configStorage = this.configStorage;
        if (configStorage.getHttpProxyHost() != null && configStorage.getHttpProxyPort() > 0) {
            this.httpProxy = new OkHttpProxyInfo(OkHttpProxyInfo.ProxyType.SOCKS5, configStorage.getHttpProxyHost(), configStorage.getHttpProxyPort(), configStorage.getHttpProxyUsername(), configStorage.getHttpProxyPassword());
        }
        this.httpClient = new ConnectionPool();
    }

    @Override
    public WxCpConfigStorage getWxCpConfigStorage() {
        return this.configStorage;
    }
}

