/*
 * Decompiled with CFR 0.152.
 */
package me.chanjar.weixin.cp.bean;

import com.google.common.base.Splitter;
import com.google.gson.annotations.SerializedName;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import me.chanjar.weixin.common.util.ToStringUtils;
import me.chanjar.weixin.cp.util.json.WxCpGsonBuilder;
import org.apache.commons.lang3.StringUtils;

public class WxCpInviteResult
implements Serializable {
    private static final long serialVersionUID = 1420065684270213578L;
    @SerializedName(value="errcode")
    private Integer errCode;
    @SerializedName(value="errmsg")
    private String errMsg;
    @SerializedName(value="invaliduser")
    private String invalidUsers;
    @SerializedName(value="invalidparty")
    private String[] invalidParties;
    @SerializedName(value="invalidtag")
    private String[] invalidTags;

    public String toString() {
        return ToStringUtils.toSimpleString((Object)this);
    }

    public static WxCpInviteResult fromJson(String json) {
        return (WxCpInviteResult)WxCpGsonBuilder.INSTANCE.create().fromJson(json, WxCpInviteResult.class);
    }

    public List<String> getInvalidUserList() {
        return this.content2List(this.invalidUsers);
    }

    private List<String> content2List(String content) {
        if (StringUtils.isBlank((CharSequence)content)) {
            return Collections.emptyList();
        }
        return Splitter.on((String)"|").splitToList((CharSequence)content);
    }

    public Integer getErrCode() {
        return this.errCode;
    }

    public String getErrMsg() {
        return this.errMsg;
    }

    public String getInvalidUsers() {
        return this.invalidUsers;
    }

    public String[] getInvalidParties() {
        return this.invalidParties;
    }

    public String[] getInvalidTags() {
        return this.invalidTags;
    }

    public void setErrCode(Integer errCode) {
        this.errCode = errCode;
    }

    public void setErrMsg(String errMsg) {
        this.errMsg = errMsg;
    }

    public void setInvalidUsers(String invalidUsers) {
        this.invalidUsers = invalidUsers;
    }

    public void setInvalidParties(String[] invalidParties) {
        this.invalidParties = invalidParties;
    }

    public void setInvalidTags(String[] invalidTags) {
        this.invalidTags = invalidTags;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof WxCpInviteResult)) {
            return false;
        }
        WxCpInviteResult other = (WxCpInviteResult)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$errCode = this.getErrCode();
        Integer other$errCode = other.getErrCode();
        if (this$errCode == null ? other$errCode != null : !((Object)this$errCode).equals(other$errCode)) {
            return false;
        }
        String this$errMsg = this.getErrMsg();
        String other$errMsg = other.getErrMsg();
        if (this$errMsg == null ? other$errMsg != null : !this$errMsg.equals(other$errMsg)) {
            return false;
        }
        String this$invalidUsers = this.getInvalidUsers();
        String other$invalidUsers = other.getInvalidUsers();
        if (this$invalidUsers == null ? other$invalidUsers != null : !this$invalidUsers.equals(other$invalidUsers)) {
            return false;
        }
        if (!Arrays.deepEquals(this.getInvalidParties(), other.getInvalidParties())) {
            return false;
        }
        return Arrays.deepEquals(this.getInvalidTags(), other.getInvalidTags());
    }

    protected boolean canEqual(Object other) {
        return other instanceof WxCpInviteResult;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $errCode = this.getErrCode();
        result = result * 59 + ($errCode == null ? 43 : ((Object)$errCode).hashCode());
        String $errMsg = this.getErrMsg();
        result = result * 59 + ($errMsg == null ? 43 : $errMsg.hashCode());
        String $invalidUsers = this.getInvalidUsers();
        result = result * 59 + ($invalidUsers == null ? 43 : $invalidUsers.hashCode());
        result = result * 59 + Arrays.deepHashCode(this.getInvalidParties());
        result = result * 59 + Arrays.deepHashCode(this.getInvalidTags());
        return result;
    }
}

