/*
 * Decompiled with CFR 0.152.
 */
package me.chanjar.weixin.cp.api.impl;

import com.google.common.base.Joiner;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import me.chanjar.weixin.common.bean.WxJsapiSignature;
import me.chanjar.weixin.common.error.WxError;
import me.chanjar.weixin.common.error.WxErrorException;
import me.chanjar.weixin.common.session.StandardSessionManager;
import me.chanjar.weixin.common.session.WxSession;
import me.chanjar.weixin.common.session.WxSessionManager;
import me.chanjar.weixin.common.util.DataUtils;
import me.chanjar.weixin.common.util.RandomUtils;
import me.chanjar.weixin.common.util.crypto.SHA1;
import me.chanjar.weixin.common.util.http.RequestExecutor;
import me.chanjar.weixin.common.util.http.RequestHttp;
import me.chanjar.weixin.common.util.http.SimpleGetRequestExecutor;
import me.chanjar.weixin.common.util.http.SimplePostRequestExecutor;
import me.chanjar.weixin.cp.api.WxCpAgentService;
import me.chanjar.weixin.cp.api.WxCpChatService;
import me.chanjar.weixin.cp.api.WxCpDepartmentService;
import me.chanjar.weixin.cp.api.WxCpMediaService;
import me.chanjar.weixin.cp.api.WxCpMenuService;
import me.chanjar.weixin.cp.api.WxCpOAService;
import me.chanjar.weixin.cp.api.WxCpOAuth2Service;
import me.chanjar.weixin.cp.api.WxCpService;
import me.chanjar.weixin.cp.api.WxCpTagService;
import me.chanjar.weixin.cp.api.WxCpUserService;
import me.chanjar.weixin.cp.api.impl.WxCpAgentServiceImpl;
import me.chanjar.weixin.cp.api.impl.WxCpChatServiceImpl;
import me.chanjar.weixin.cp.api.impl.WxCpDepartmentServiceImpl;
import me.chanjar.weixin.cp.api.impl.WxCpMediaServiceImpl;
import me.chanjar.weixin.cp.api.impl.WxCpMenuServiceImpl;
import me.chanjar.weixin.cp.api.impl.WxCpOAServiceImpl;
import me.chanjar.weixin.cp.api.impl.WxCpOAuth2ServiceImpl;
import me.chanjar.weixin.cp.api.impl.WxCpTagServiceImpl;
import me.chanjar.weixin.cp.api.impl.WxCpUserServiceImpl;
import me.chanjar.weixin.cp.bean.WxCpMaJsCode2SessionResult;
import me.chanjar.weixin.cp.bean.WxCpMessage;
import me.chanjar.weixin.cp.bean.WxCpMessageSendResult;
import me.chanjar.weixin.cp.config.WxCpConfigStorage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseWxCpServiceImpl<H, P>
implements WxCpService,
RequestHttp<H, P> {
    protected final Logger log = LoggerFactory.getLogger(this.getClass());
    private WxCpUserService userService = new WxCpUserServiceImpl(this);
    private WxCpChatService chatService = new WxCpChatServiceImpl(this);
    private WxCpDepartmentService departmentService = new WxCpDepartmentServiceImpl(this);
    private WxCpMediaService mediaService = new WxCpMediaServiceImpl(this);
    private WxCpMenuService menuService = new WxCpMenuServiceImpl(this);
    private WxCpOAuth2Service oauth2Service = new WxCpOAuth2ServiceImpl(this);
    private WxCpTagService tagService = new WxCpTagServiceImpl(this);
    private WxCpAgentService agentService = new WxCpAgentServiceImpl(this);
    private WxCpOAService oaService = new WxCpOAServiceImpl(this);
    protected final Object globalAccessTokenRefreshLock = new Object();
    protected final Object globalJsapiTicketRefreshLock = new Object();
    protected final Object globalAgentJsapiTicketRefreshLock = new Object();
    protected WxCpConfigStorage configStorage;
    private WxSessionManager sessionManager = new StandardSessionManager();
    private File tmpDirFile;
    private int retrySleepMillis = 1000;
    private int maxRetryTimes = 5;

    @Override
    public boolean checkSignature(String msgSignature, String timestamp, String nonce, String data) {
        try {
            return SHA1.gen((String[])new String[]{this.configStorage.getToken(), timestamp, nonce, data}).equals(msgSignature);
        }
        catch (Exception e) {
            this.log.error("Checking signature failed, and the reason is :" + e.getMessage());
            return false;
        }
    }

    @Override
    public String getAccessToken() throws WxErrorException {
        return this.getAccessToken(false);
    }

    @Override
    public String getAgentJsapiTicket() throws WxErrorException {
        return this.getAgentJsapiTicket(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getAgentJsapiTicket(boolean forceRefresh) throws WxErrorException {
        if (forceRefresh) {
            this.configStorage.expireAgentJsapiTicket();
        }
        if (this.configStorage.isAgentJsapiTicketExpired()) {
            Object object = this.globalAgentJsapiTicketRefreshLock;
            synchronized (object) {
                if (this.configStorage.isAgentJsapiTicketExpired()) {
                    String responseContent = this.get("https://qyapi.weixin.qq.com/cgi-bin/ticket/get?&type=agent_config", null);
                    JsonObject jsonObject = new JsonParser().parse(responseContent).getAsJsonObject();
                    this.configStorage.updateAgentJsapiTicket(jsonObject.get("ticket").getAsString(), jsonObject.get("expires_in").getAsInt());
                }
            }
        }
        return this.configStorage.getAgentJsapiTicket();
    }

    @Override
    public String getJsapiTicket() throws WxErrorException {
        return this.getJsapiTicket(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getJsapiTicket(boolean forceRefresh) throws WxErrorException {
        if (forceRefresh) {
            this.configStorage.expireJsapiTicket();
        }
        if (this.configStorage.isJsapiTicketExpired()) {
            Object object = this.globalJsapiTicketRefreshLock;
            synchronized (object) {
                if (this.configStorage.isJsapiTicketExpired()) {
                    String responseContent = this.get("https://qyapi.weixin.qq.com/cgi-bin/get_jsapi_ticket", null);
                    JsonObject tmpJsonObject = new JsonParser().parse(responseContent).getAsJsonObject();
                    this.configStorage.updateJsapiTicket(tmpJsonObject.get("ticket").getAsString(), tmpJsonObject.get("expires_in").getAsInt());
                }
            }
        }
        return this.configStorage.getJsapiTicket();
    }

    @Override
    public WxJsapiSignature createJsapiSignature(String url) throws WxErrorException {
        long timestamp = System.currentTimeMillis() / 1000L;
        String noncestr = RandomUtils.getRandomStr();
        String jsapiTicket = this.getJsapiTicket(false);
        String signature = SHA1.genWithAmple((String[])new String[]{"jsapi_ticket=" + jsapiTicket, "noncestr=" + noncestr, "timestamp=" + timestamp, "url=" + url});
        WxJsapiSignature jsapiSignature = new WxJsapiSignature();
        jsapiSignature.setTimestamp(timestamp);
        jsapiSignature.setNonceStr(noncestr);
        jsapiSignature.setUrl(url);
        jsapiSignature.setSignature(signature);
        jsapiSignature.setAppId(this.configStorage.getCorpId());
        return jsapiSignature;
    }

    @Override
    public WxCpMessageSendResult messageSend(WxCpMessage message) throws WxErrorException {
        Integer agentId = message.getAgentId();
        if (null == agentId) {
            message.setAgentId(this.getWxCpConfigStorage().getAgentId());
        }
        return WxCpMessageSendResult.fromJson(this.post("https://qyapi.weixin.qq.com/cgi-bin/message/send", message.toJson()));
    }

    @Override
    public WxCpMaJsCode2SessionResult jsCode2Session(String jsCode) throws WxErrorException {
        HashMap<String, String> params = new HashMap<String, String>(2);
        params.put("js_code", jsCode);
        params.put("grant_type", "authorization_code");
        String result = this.get("https://qyapi.weixin.qq.com/cgi-bin/miniprogram/jscode2session", Joiner.on((String)"&").withKeyValueSeparator("=").join(params));
        return WxCpMaJsCode2SessionResult.fromJson(result);
    }

    @Override
    public String[] getCallbackIp() throws WxErrorException {
        String responseContent = this.get("https://qyapi.weixin.qq.com/cgi-bin/getcallbackip", null);
        JsonElement tmpJsonElement = new JsonParser().parse(responseContent);
        JsonArray jsonArray = tmpJsonElement.getAsJsonObject().get("ip_list").getAsJsonArray();
        String[] ips = new String[jsonArray.size()];
        for (int i = 0; i < jsonArray.size(); ++i) {
            ips[i] = jsonArray.get(i).getAsString();
        }
        return ips;
    }

    @Override
    public String get(String url, String queryParam) throws WxErrorException {
        return (String)this.execute(SimpleGetRequestExecutor.create((RequestHttp)this), url, queryParam);
    }

    @Override
    public String post(String url, String postData) throws WxErrorException {
        return (String)this.execute(SimplePostRequestExecutor.create((RequestHttp)this), url, postData);
    }

    @Override
    public <T, E> T execute(RequestExecutor<T, E> executor, String uri, E data) throws WxErrorException {
        int retryTimes = 0;
        while (true) {
            try {
                return this.executeInternal(executor, uri, data);
            }
            catch (WxErrorException e) {
                if (retryTimes + 1 > this.maxRetryTimes) {
                    this.log.warn("\u91cd\u8bd5\u8fbe\u5230\u6700\u5927\u6b21\u6570\u3010{}\u3011", (Object)this.maxRetryTimes);
                    throw new RuntimeException("\u5fae\u4fe1\u670d\u52a1\u7aef\u5f02\u5e38\uff0c\u8d85\u51fa\u91cd\u8bd5\u6b21\u6570");
                }
                WxError error = e.getError();
                if (error.getErrorCode() == -1) {
                    int sleepMillis = this.retrySleepMillis * (1 << retryTimes);
                    try {
                        this.log.debug("\u5fae\u4fe1\u7cfb\u7edf\u7e41\u5fd9\uff0c{} ms \u540e\u91cd\u8bd5(\u7b2c{}\u6b21)", (Object)sleepMillis, (Object)(retryTimes + 1));
                        Thread.sleep(sleepMillis);
                    }
                    catch (InterruptedException e1) {
                        Thread.currentThread().interrupt();
                    }
                    continue;
                }
                throw e;
                if (retryTimes++ < this.maxRetryTimes) continue;
                this.log.warn("\u91cd\u8bd5\u8fbe\u5230\u6700\u5927\u6b21\u6570\u3010{}\u3011", (Object)this.maxRetryTimes);
                throw new RuntimeException("\u5fae\u4fe1\u670d\u52a1\u7aef\u5f02\u5e38\uff0c\u8d85\u51fa\u91cd\u8bd5\u6b21\u6570");
            }
            break;
        }
    }

    protected <T, E> T executeInternal(RequestExecutor<T, E> executor, String uri, E data) throws WxErrorException {
        Object dataForLog = DataUtils.handleDataWithSecret(data);
        if (uri.contains("access_token=")) {
            throw new IllegalArgumentException("uri\u53c2\u6570\u4e2d\u4e0d\u5141\u8bb8\u6709access_token: " + uri);
        }
        String accessToken = this.getAccessToken(false);
        String uriWithAccessToken = uri + (uri.contains("?") ? "&" : "?") + "access_token=" + accessToken;
        try {
            Object result = executor.execute(uriWithAccessToken, data);
            this.log.debug("\n\u3010\u8bf7\u6c42\u5730\u5740\u3011: {}\n\u3010\u8bf7\u6c42\u53c2\u6570\u3011\uff1a{}\n\u3010\u54cd\u5e94\u6570\u636e\u3011\uff1a{}", new Object[]{uriWithAccessToken, dataForLog, result});
            return (T)result;
        }
        catch (WxErrorException e) {
            WxError error = e.getError();
            if (error.getErrorCode() == 42001 || error.getErrorCode() == 40001 || error.getErrorCode() == 40014) {
                this.configStorage.expireAccessToken();
                return this.execute(executor, uri, data);
            }
            if (error.getErrorCode() != 0) {
                this.log.error("\n\u3010\u8bf7\u6c42\u5730\u5740\u3011: {}\n\u3010\u8bf7\u6c42\u53c2\u6570\u3011\uff1a{}\n\u3010\u9519\u8bef\u4fe1\u606f\u3011\uff1a{}", new Object[]{uriWithAccessToken, dataForLog, error});
                throw new WxErrorException(error, (Throwable)e);
            }
            return null;
        }
        catch (IOException e) {
            this.log.error("\n\u3010\u8bf7\u6c42\u5730\u5740\u3011: {}\n\u3010\u8bf7\u6c42\u53c2\u6570\u3011\uff1a{}\n\u3010\u5f02\u5e38\u4fe1\u606f\u3011\uff1a{}", new Object[]{uriWithAccessToken, dataForLog, e.getMessage()});
            throw new RuntimeException(e);
        }
    }

    @Override
    public void setWxCpConfigStorage(WxCpConfigStorage wxConfigProvider) {
        this.configStorage = wxConfigProvider;
        this.initHttp();
    }

    @Override
    public void setRetrySleepMillis(int retrySleepMillis) {
        this.retrySleepMillis = retrySleepMillis;
    }

    @Override
    public void setMaxRetryTimes(int maxRetryTimes) {
        this.maxRetryTimes = maxRetryTimes;
    }

    @Override
    public WxSession getSession(String id) {
        if (this.sessionManager == null) {
            return null;
        }
        return this.sessionManager.getSession(id);
    }

    @Override
    public WxSession getSession(String id, boolean create) {
        if (this.sessionManager == null) {
            return null;
        }
        return this.sessionManager.getSession(id, create);
    }

    @Override
    public void setSessionManager(WxSessionManager sessionManager) {
        this.sessionManager = sessionManager;
    }

    @Override
    public WxSessionManager getSessionManager() {
        return this.sessionManager;
    }

    @Override
    public String replaceParty(String mediaId) throws WxErrorException {
        JsonObject jsonObject = new JsonObject();
        jsonObject.addProperty("media_id", mediaId);
        return this.post("https://qyapi.weixin.qq.com/cgi-bin/batch/replaceparty", jsonObject.toString());
    }

    @Override
    public String replaceUser(String mediaId) throws WxErrorException {
        JsonObject jsonObject = new JsonObject();
        jsonObject.addProperty("media_id", mediaId);
        return this.post("https://qyapi.weixin.qq.com/cgi-bin/batch/replaceuser", jsonObject.toString());
    }

    @Override
    public String getTaskResult(String joinId) throws WxErrorException {
        String url = "https://qyapi.weixin.qq.com/cgi-bin/batch/getresult?jobid=" + joinId;
        return this.get(url, null);
    }

    public File getTmpDirFile() {
        return this.tmpDirFile;
    }

    public void setTmpDirFile(File tmpDirFile) {
        this.tmpDirFile = tmpDirFile;
    }

    @Override
    public WxCpDepartmentService getDepartmentService() {
        return this.departmentService;
    }

    @Override
    public WxCpMediaService getMediaService() {
        return this.mediaService;
    }

    @Override
    public WxCpMenuService getMenuService() {
        return this.menuService;
    }

    @Override
    public WxCpOAuth2Service getOauth2Service() {
        return this.oauth2Service;
    }

    @Override
    public WxCpTagService getTagService() {
        return this.tagService;
    }

    @Override
    public WxCpUserService getUserService() {
        return this.userService;
    }

    @Override
    public WxCpChatService getChatService() {
        return this.chatService;
    }

    @Override
    public WxCpOAService getOAService() {
        return this.oaService;
    }

    @Override
    public RequestHttp<?, ?> getRequestHttp() {
        return this;
    }

    @Override
    public void setUserService(WxCpUserService userService) {
        this.userService = userService;
    }

    @Override
    public void setDepartmentService(WxCpDepartmentService departmentService) {
        this.departmentService = departmentService;
    }

    @Override
    public void setMediaService(WxCpMediaService mediaService) {
        this.mediaService = mediaService;
    }

    @Override
    public void setMenuService(WxCpMenuService menuService) {
        this.menuService = menuService;
    }

    @Override
    public void setOauth2Service(WxCpOAuth2Service oauth2Service) {
        this.oauth2Service = oauth2Service;
    }

    @Override
    public void setTagService(WxCpTagService tagService) {
        this.tagService = tagService;
    }

    @Override
    public WxCpAgentService getAgentService() {
        return this.agentService;
    }

    public void setAgentService(WxCpAgentService agentService) {
        this.agentService = agentService;
    }
}

