/*
 * Decompiled with CFR 0.152.
 */
package me.chanjar.weixin.cp.api.impl;

import com.google.common.base.Joiner;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import me.chanjar.weixin.common.WxType;
import me.chanjar.weixin.common.bean.WxAccessToken;
import me.chanjar.weixin.common.error.WxError;
import me.chanjar.weixin.common.error.WxErrorException;
import me.chanjar.weixin.common.util.DataUtils;
import me.chanjar.weixin.common.util.crypto.SHA1;
import me.chanjar.weixin.common.util.http.RequestExecutor;
import me.chanjar.weixin.common.util.http.RequestHttp;
import me.chanjar.weixin.common.util.http.SimpleGetRequestExecutor;
import me.chanjar.weixin.common.util.http.SimplePostRequestExecutor;
import me.chanjar.weixin.cp.api.WxCpTpService;
import me.chanjar.weixin.cp.bean.WxCpMaJsCode2SessionResult;
import me.chanjar.weixin.cp.bean.WxCpTpCorp;
import me.chanjar.weixin.cp.config.WxCpTpConfigStorage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseWxCpTpServiceImpl<H, P>
implements WxCpTpService,
RequestHttp<H, P> {
    private static final Logger log = LoggerFactory.getLogger(BaseWxCpTpServiceImpl.class);
    protected final Object globalSuiteAccessTokenRefreshLock = new Object();
    protected final Object globalSuiteTicketRefreshLock = new Object();
    protected WxCpTpConfigStorage configStorage;
    private File tmpDirFile;
    private int retrySleepMillis = 1000;
    private int maxRetryTimes = 5;

    @Override
    public boolean checkSignature(String msgSignature, String timestamp, String nonce, String data) {
        try {
            return SHA1.gen((String[])new String[]{this.configStorage.getToken(), timestamp, nonce, data}).equals(msgSignature);
        }
        catch (Exception e) {
            log.error("Checking signature failed, and the reason is :" + e.getMessage());
            return false;
        }
    }

    @Override
    public String getSuiteAccessToken() throws WxErrorException {
        return this.getSuiteAccessToken(false);
    }

    @Override
    public String getSuiteTicket() throws WxErrorException {
        return this.getSuiteTicket(false);
    }

    @Override
    public String getSuiteTicket(boolean forceRefresh) throws WxErrorException {
        if (this.configStorage.isSuiteTicketExpired()) {
            WxError wxError = WxError.fromJson((String)"{\"errcode\":40085, \"errmsg\":\"invaild suite ticket\"}", (WxType)WxType.CP);
            throw new WxErrorException(wxError);
        }
        return this.configStorage.getSuiteTicket();
    }

    @Override
    public WxCpMaJsCode2SessionResult jsCode2Session(String jsCode) throws WxErrorException {
        HashMap<String, String> params = new HashMap<String, String>(2);
        params.put("js_code", jsCode);
        params.put("grant_type", "authorization_code");
        String url = this.configStorage.getApiUrl("/cgi-bin/service/miniprogram/jscode2session");
        return WxCpMaJsCode2SessionResult.fromJson(this.get(url, Joiner.on((String)"&").withKeyValueSeparator("=").join(params)));
    }

    @Override
    public WxAccessToken getCorpToken(String authCorpid, String permanentCode) throws WxErrorException {
        JsonObject jsonObject = new JsonObject();
        jsonObject.addProperty("auth_corpid", authCorpid);
        jsonObject.addProperty("permanent_code", permanentCode);
        String result = this.post(this.configStorage.getApiUrl("/cgi-bin/service/get_corp_token"), jsonObject.toString());
        return WxAccessToken.fromJson((String)result);
    }

    @Override
    public WxCpTpCorp getPermanentCode(String authCode) throws WxErrorException {
        JsonObject jsonObject = new JsonObject();
        jsonObject.addProperty("auth_code", authCode);
        String result = this.post(this.configStorage.getApiUrl("/cgi-bin/service/get_permanent_code"), jsonObject.toString());
        jsonObject = new JsonParser().parse(result).getAsJsonObject();
        WxCpTpCorp wxCpTpCorp = WxCpTpCorp.fromJson(jsonObject.get("auth_corp_info").getAsJsonObject().toString());
        wxCpTpCorp.setPermanentCode(jsonObject.get("permanent_code").getAsString());
        return wxCpTpCorp;
    }

    @Override
    public String get(String url, String queryParam) throws WxErrorException {
        return (String)this.execute(SimpleGetRequestExecutor.create((RequestHttp)this), url, queryParam);
    }

    @Override
    public String post(String url, String postData) throws WxErrorException {
        return (String)this.execute(SimplePostRequestExecutor.create((RequestHttp)this), url, postData);
    }

    @Override
    public <T, E> T execute(RequestExecutor<T, E> executor, String uri, E data) throws WxErrorException {
        int retryTimes = 0;
        while (true) {
            try {
                return this.executeInternal(executor, uri, data);
            }
            catch (WxErrorException e) {
                if (retryTimes + 1 > this.maxRetryTimes) {
                    log.warn("\u91cd\u8bd5\u8fbe\u5230\u6700\u5927\u6b21\u6570\u3010{}\u3011", (Object)this.maxRetryTimes);
                    throw new RuntimeException("\u5fae\u4fe1\u670d\u52a1\u7aef\u5f02\u5e38\uff0c\u8d85\u51fa\u91cd\u8bd5\u6b21\u6570");
                }
                WxError error = e.getError();
                if (error.getErrorCode() == -1) {
                    int sleepMillis = this.retrySleepMillis * (1 << retryTimes);
                    try {
                        log.debug("\u5fae\u4fe1\u7cfb\u7edf\u7e41\u5fd9\uff0c{} ms \u540e\u91cd\u8bd5(\u7b2c{}\u6b21)", (Object)sleepMillis, (Object)(retryTimes + 1));
                        Thread.sleep(sleepMillis);
                    }
                    catch (InterruptedException e1) {
                        Thread.currentThread().interrupt();
                    }
                    continue;
                }
                throw e;
                if (retryTimes++ < this.maxRetryTimes) continue;
                log.warn("\u91cd\u8bd5\u8fbe\u5230\u6700\u5927\u6b21\u6570\u3010{}\u3011", (Object)this.maxRetryTimes);
                throw new RuntimeException("\u5fae\u4fe1\u670d\u52a1\u7aef\u5f02\u5e38\uff0c\u8d85\u51fa\u91cd\u8bd5\u6b21\u6570");
            }
            break;
        }
    }

    protected <T, E> T executeInternal(RequestExecutor<T, E> executor, String uri, E data) throws WxErrorException {
        Object dataForLog = DataUtils.handleDataWithSecret(data);
        if (uri.contains("suite_access_token=")) {
            throw new IllegalArgumentException("uri\u53c2\u6570\u4e2d\u4e0d\u5141\u8bb8\u6709suite_access_token: " + uri);
        }
        String suiteAccessToken = this.getSuiteAccessToken(false);
        String uriWithAccessToken = uri + (uri.contains("?") ? "&" : "?") + "suite_access_token=" + suiteAccessToken;
        try {
            Object result = executor.execute(uriWithAccessToken, data);
            log.debug("\n\u3010\u8bf7\u6c42\u5730\u5740\u3011: {}\n\u3010\u8bf7\u6c42\u53c2\u6570\u3011\uff1a{}\n\u3010\u54cd\u5e94\u6570\u636e\u3011\uff1a{}", new Object[]{uriWithAccessToken, dataForLog, result});
            return (T)result;
        }
        catch (WxErrorException e) {
            WxError error = e.getError();
            if (error.getErrorCode() == 42009) {
                this.configStorage.expireSuiteAccessToken();
                return this.execute(executor, uri, data);
            }
            if (error.getErrorCode() != 0) {
                log.error("\n\u3010\u8bf7\u6c42\u5730\u5740\u3011: {}\n\u3010\u8bf7\u6c42\u53c2\u6570\u3011\uff1a{}\n\u3010\u9519\u8bef\u4fe1\u606f\u3011\uff1a{}", new Object[]{uriWithAccessToken, dataForLog, error});
                throw new WxErrorException(error, (Throwable)e);
            }
            return null;
        }
        catch (IOException e) {
            log.error("\n\u3010\u8bf7\u6c42\u5730\u5740\u3011: {}\n\u3010\u8bf7\u6c42\u53c2\u6570\u3011\uff1a{}\n\u3010\u5f02\u5e38\u4fe1\u606f\u3011\uff1a{}", new Object[]{uriWithAccessToken, dataForLog, e.getMessage()});
            throw new RuntimeException(e);
        }
    }

    @Override
    public void setWxCpTpConfigStorage(WxCpTpConfigStorage wxConfigProvider) {
        this.configStorage = wxConfigProvider;
        this.initHttp();
    }

    @Override
    public void setRetrySleepMillis(int retrySleepMillis) {
        this.retrySleepMillis = retrySleepMillis;
    }

    @Override
    public void setMaxRetryTimes(int maxRetryTimes) {
        this.maxRetryTimes = maxRetryTimes;
    }

    public File getTmpDirFile() {
        return this.tmpDirFile;
    }

    public void setTmpDirFile(File tmpDirFile) {
        this.tmpDirFile = tmpDirFile;
    }

    @Override
    public RequestHttp<?, ?> getRequestHttp() {
        return this;
    }
}

