/*
 * Decompiled with CFR 0.152.
 */
package me.chanjar.weixin.cp.util.json;

import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;
import me.chanjar.weixin.common.util.json.GsonHelper;
import me.chanjar.weixin.cp.bean.Gender;
import me.chanjar.weixin.cp.bean.WxCpUser;

public class WxCpUserGsonAdapter
implements JsonDeserializer<WxCpUser>,
JsonSerializer<WxCpUser> {
    private static final String EXTERNAL_PROFILE = "external_profile";
    private static final String EXTERNAL_ATTR = "external_attr";
    private static final String EXTATTR = "extattr";

    public WxCpUser deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        int i;
        JsonArray departJsonArray;
        JsonObject o = json.getAsJsonObject();
        WxCpUser user = new WxCpUser();
        if (o.get("department") != null) {
            departJsonArray = o.get("department").getAsJsonArray();
            Long[] departIds = new Long[departJsonArray.size()];
            i = 0;
            for (JsonElement jsonElement : departJsonArray) {
                departIds[i++] = jsonElement.getAsLong();
            }
            user.setDepartIds(departIds);
        }
        if (o.get("order") != null) {
            departJsonArray = o.get("order").getAsJsonArray();
            Integer[] orders = new Integer[departJsonArray.size()];
            i = 0;
            for (JsonElement jsonElement : departJsonArray) {
                orders[i++] = jsonElement.getAsInt();
            }
            user.setOrders(orders);
        }
        user.setUserId(GsonHelper.getString((JsonObject)o, (String)"userid"));
        user.setName(GsonHelper.getString((JsonObject)o, (String)"name"));
        user.setPosition(GsonHelper.getString((JsonObject)o, (String)"position"));
        user.setMobile(GsonHelper.getString((JsonObject)o, (String)"mobile"));
        user.setGender(Gender.fromCode(GsonHelper.getString((JsonObject)o, (String)"gender")));
        user.setEmail(GsonHelper.getString((JsonObject)o, (String)"email"));
        user.setAvatar(GsonHelper.getString((JsonObject)o, (String)"avatar"));
        user.setThumbAvatar(GsonHelper.getString((JsonObject)o, (String)"thumb_avatar"));
        user.setAddress(GsonHelper.getString((JsonObject)o, (String)"address"));
        user.setAvatarMediaId(GsonHelper.getString((JsonObject)o, (String)"avatar_mediaid"));
        user.setStatus(GsonHelper.getInteger((JsonObject)o, (String)"status"));
        user.setEnable(GsonHelper.getInteger((JsonObject)o, (String)"enable"));
        user.setIsLeader(GsonHelper.getInteger((JsonObject)o, (String)"isleader"));
        user.setIsLeaderInDept(GsonHelper.getIntArray((JsonObject)o, (String)"is_leader_in_dept"));
        user.setHideMobile(GsonHelper.getInteger((JsonObject)o, (String)"hide_mobile"));
        user.setEnglishName(GsonHelper.getString((JsonObject)o, (String)"english_name"));
        user.setTelephone(GsonHelper.getString((JsonObject)o, (String)"telephone"));
        user.setQrCode(GsonHelper.getString((JsonObject)o, (String)"qr_code"));
        user.setToInvite(GsonHelper.getBoolean((JsonObject)o, (String)"to_invite"));
        if (GsonHelper.isNotNull((JsonElement)o.get(EXTATTR))) {
            this.buildExtraAttrs(o, user);
        }
        if (GsonHelper.isNotNull((JsonElement)o.get(EXTERNAL_PROFILE))) {
            this.buildExternalAttrs(o, user);
        }
        return user;
    }

    private void buildExtraAttrs(JsonObject o, WxCpUser user) {
        JsonArray attrJsonElements = o.get(EXTATTR).getAsJsonObject().get("attrs").getAsJsonArray();
        for (JsonElement attrJsonElement : attrJsonElements) {
            WxCpUser.Attr attr = new WxCpUser.Attr(GsonHelper.getString((JsonObject)attrJsonElement.getAsJsonObject(), (String)"name"), GsonHelper.getString((JsonObject)attrJsonElement.getAsJsonObject(), (String)"value"));
            user.getExtAttrs().add(attr);
        }
    }

    private void buildExternalAttrs(JsonObject o, WxCpUser user) {
        JsonArray attrJsonElements = o.get(EXTERNAL_PROFILE).getAsJsonObject().get(EXTERNAL_ATTR).getAsJsonArray();
        for (JsonElement element : attrJsonElements) {
            Integer type = GsonHelper.getInteger((JsonObject)element.getAsJsonObject(), (String)"type");
            String name = GsonHelper.getString((JsonObject)element.getAsJsonObject(), (String)"name");
            switch (type) {
                case 0: {
                    user.getExternalAttrs().add(WxCpUser.ExternalAttribute.builder().type(type).name(name).value(GsonHelper.getString((JsonObject)element.getAsJsonObject().get("text").getAsJsonObject(), (String)"value")).build());
                    break;
                }
                case 1: {
                    JsonObject web = element.getAsJsonObject().get("web").getAsJsonObject();
                    user.getExternalAttrs().add(WxCpUser.ExternalAttribute.builder().type(type).name(name).url(GsonHelper.getString((JsonObject)web, (String)"url")).title(GsonHelper.getString((JsonObject)web, (String)"title")).build());
                    break;
                }
                case 2: {
                    JsonObject miniprogram = element.getAsJsonObject().get("miniprogram").getAsJsonObject();
                    user.getExternalAttrs().add(WxCpUser.ExternalAttribute.builder().type(type).name(name).appid(GsonHelper.getString((JsonObject)miniprogram, (String)"appid")).pagePath(GsonHelper.getString((JsonObject)miniprogram, (String)"pagepath")).title(GsonHelper.getString((JsonObject)miniprogram, (String)"title")).build());
                    break;
                }
            }
        }
    }

    public JsonElement serialize(WxCpUser user, Type typeOfSrc, JsonSerializationContext context) {
        JsonObject attrsJson;
        JsonArray attrsJsonArray;
        JsonArray jsonArray;
        JsonObject o = new JsonObject();
        if (user.getUserId() != null) {
            o.addProperty("userid", user.getUserId());
        }
        if (user.getName() != null) {
            o.addProperty("name", user.getName());
        }
        if (user.getDepartIds() != null) {
            jsonArray = new JsonArray();
            for (Number number : user.getDepartIds()) {
                jsonArray.add((JsonElement)new JsonPrimitive(number));
            }
            o.add("department", (JsonElement)jsonArray);
        }
        if (user.getOrders() != null) {
            jsonArray = new JsonArray();
            for (Number number : user.getOrders()) {
                jsonArray.add((JsonElement)new JsonPrimitive(number));
            }
            o.add("order", (JsonElement)jsonArray);
        }
        if (user.getPosition() != null) {
            o.addProperty("position", user.getPosition());
        }
        if (user.getMobile() != null) {
            o.addProperty("mobile", user.getMobile());
        }
        if (user.getGender() != null) {
            o.addProperty("gender", user.getGender().getCode());
        }
        if (user.getEmail() != null) {
            o.addProperty("email", user.getEmail());
        }
        if (user.getAvatar() != null) {
            o.addProperty("avatar", user.getAvatar());
        }
        if (user.getThumbAvatar() != null) {
            o.addProperty("thumb_avatar", user.getThumbAvatar());
        }
        if (user.getAddress() != null) {
            o.addProperty("address", user.getAddress());
        }
        if (user.getAvatarMediaId() != null) {
            o.addProperty("avatar_mediaid", user.getAvatarMediaId());
        }
        if (user.getStatus() != null) {
            o.addProperty("status", (Number)user.getStatus());
        }
        if (user.getEnable() != null) {
            o.addProperty("enable", (Number)user.getEnable());
        }
        if (user.getIsLeader() != null) {
            o.addProperty("isleader", (Number)user.getIsLeader());
        }
        if (user.getIsLeaderInDept() != null && user.getIsLeaderInDept().length > 0) {
            JsonArray ary = new JsonArray();
            Integer[] integerArray = user.getIsLeaderInDept();
            int n = integerArray.length;
            for (int i = 0; i < n; ++i) {
                int n2 = (Integer)integerArray[i];
                ary.add((Number)n2);
            }
            o.add("is_leader_in_dept", (JsonElement)ary);
        }
        if (user.getHideMobile() != null) {
            o.addProperty("hide_mobile", (Number)user.getHideMobile());
        }
        if (user.getEnglishName() != null) {
            o.addProperty("english_name", user.getEnglishName());
        }
        if (user.getTelephone() != null) {
            o.addProperty("telephone", user.getTelephone());
        }
        if (user.getQrCode() != null) {
            o.addProperty("qr_code", user.getQrCode());
        }
        if (user.getToInvite() != null) {
            o.addProperty("to_invite", user.getToInvite());
        }
        if (user.getExtAttrs().size() > 0) {
            attrsJsonArray = new JsonArray();
            for (WxCpUser.Attr attr : user.getExtAttrs()) {
                JsonObject attrJson = new JsonObject();
                attrJson.addProperty("name", attr.getName());
                attrJson.addProperty("value", attr.getValue());
                attrsJsonArray.add((JsonElement)attrJson);
            }
            attrsJson = new JsonObject();
            attrsJson.add("attrs", (JsonElement)attrsJsonArray);
            o.add(EXTATTR, (JsonElement)attrsJson);
        }
        if (user.getExternalAttrs().size() > 0) {
            attrsJsonArray = new JsonArray();
            for (WxCpUser.ExternalAttribute attr : user.getExternalAttrs()) {
                JsonObject attrJson = new JsonObject();
                attrJson.addProperty("type", (Number)attr.getType());
                attrJson.addProperty("name", attr.getName());
                switch (attr.getType()) {
                    case 0: {
                        JsonObject jsonObject = new JsonObject();
                        jsonObject.addProperty("value", attr.getValue());
                        attrJson.add("text", (JsonElement)jsonObject);
                        break;
                    }
                    case 1: {
                        JsonObject jsonObject = new JsonObject();
                        jsonObject.addProperty("url", attr.getUrl());
                        jsonObject.addProperty("title", attr.getTitle());
                        attrJson.add("web", (JsonElement)jsonObject);
                        break;
                    }
                    case 2: {
                        JsonObject jsonObject = new JsonObject();
                        jsonObject.addProperty("appid", attr.getAppid());
                        jsonObject.addProperty("pagepath", attr.getPagePath());
                        jsonObject.addProperty("title", attr.getTitle());
                        attrJson.add("miniprogram", (JsonElement)jsonObject);
                        break;
                    }
                }
                attrsJsonArray.add((JsonElement)attrJson);
            }
            attrsJson = new JsonObject();
            attrsJson.add(EXTERNAL_ATTR, (JsonElement)attrsJsonArray);
            o.add(EXTERNAL_PROFILE, (JsonElement)attrsJson);
        }
        return o;
    }
}

