/*
 * Decompiled with CFR 0.152.
 */
package me.chanjar.weixin.cp.api.impl;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import me.chanjar.weixin.common.error.WxCpErrorMsgEnum;
import me.chanjar.weixin.common.error.WxErrorException;
import me.chanjar.weixin.cp.api.WxCpExternalContactService;
import me.chanjar.weixin.cp.api.WxCpService;
import me.chanjar.weixin.cp.bean.WxCpBaseResp;
import me.chanjar.weixin.cp.bean.WxCpUserExternalContactInfo;
import me.chanjar.weixin.cp.bean.WxCpUserExternalContactList;
import me.chanjar.weixin.cp.bean.WxCpUserExternalGroupChatInfo;
import me.chanjar.weixin.cp.bean.WxCpUserExternalGroupChatList;
import me.chanjar.weixin.cp.bean.WxCpUserExternalGroupChatStatistic;
import me.chanjar.weixin.cp.bean.WxCpUserExternalUnassignList;
import me.chanjar.weixin.cp.bean.WxCpUserExternalUserBehaviorStatistic;
import me.chanjar.weixin.cp.bean.WxCpUserWithExternalPermission;
import org.apache.commons.lang3.ArrayUtils;

public class WxCpExternalContactServiceImpl
implements WxCpExternalContactService {
    private final WxCpService mainService;

    @Override
    public WxCpUserExternalContactInfo getExternalContact(String userId) throws WxErrorException {
        String url = this.mainService.getWxCpConfigStorage().getApiUrl("/cgi-bin/crm/get_external_contact?external_userid=" + userId);
        String responseContent = this.mainService.get(url, null);
        return WxCpUserExternalContactInfo.fromJson(responseContent);
    }

    @Override
    public WxCpUserExternalContactInfo getContactDetail(String userId) throws WxErrorException {
        String url = this.mainService.getWxCpConfigStorage().getApiUrl("/cgi-bin/externalcontact/get?external_userid=" + userId);
        String responseContent = this.mainService.get(url, null);
        return WxCpUserExternalContactInfo.fromJson(responseContent);
    }

    @Override
    public List<String> listExternalContacts(String userId) throws WxErrorException {
        String url = this.mainService.getWxCpConfigStorage().getApiUrl("/cgi-bin/externalcontact/list?userid=" + userId);
        try {
            String responseContent = this.mainService.get(url, null);
            return WxCpUserExternalContactList.fromJson(responseContent).getExternalUserId();
        }
        catch (WxErrorException e) {
            if (e.getError().getErrorCode() == WxCpErrorMsgEnum.CODE_84061.getCode()) {
                return Collections.emptyList();
            }
            throw e;
        }
    }

    @Override
    public List<String> listFollowers() throws WxErrorException {
        String url = this.mainService.getWxCpConfigStorage().getApiUrl("/cgi-bin/externalcontact/get_follow_user_list");
        String responseContent = this.mainService.get(url, null);
        return WxCpUserWithExternalPermission.fromJson(responseContent).getFollowers();
    }

    @Override
    public WxCpUserExternalUnassignList listUnassignedList(Integer pageIndex, Integer pageSize) throws WxErrorException {
        JsonObject json = new JsonObject();
        json.addProperty("page_id", (Number)(pageIndex == null ? 0 : pageIndex));
        json.addProperty("page_size", (Number)(pageSize == null ? 100 : pageSize));
        String url = this.mainService.getWxCpConfigStorage().getApiUrl("/cgi-bin/externalcontact/get_unassigned_list");
        String result = this.mainService.post(url, json.toString());
        return WxCpUserExternalUnassignList.fromJson(result);
    }

    @Override
    public WxCpBaseResp transferExternalContact(String externalUserid, String handOverUserid, String takeOverUserid) throws WxErrorException {
        JsonObject json = new JsonObject();
        json.addProperty("external_userid", externalUserid);
        json.addProperty("handover_userid", handOverUserid);
        json.addProperty("takeover_userid", takeOverUserid);
        String url = this.mainService.getWxCpConfigStorage().getApiUrl("/cgi-bin/externalcontact/transfer");
        String result = this.mainService.post(url, json.toString());
        return WxCpBaseResp.fromJson(result);
    }

    @Override
    public WxCpUserExternalGroupChatList listGroupChat(Integer pageIndex, Integer pageSize, int status, String[] userIds, String[] partyIds) throws WxErrorException {
        JsonObject json = new JsonObject();
        json.addProperty("offset", (Number)(pageIndex == null ? 0 : pageIndex));
        json.addProperty("limit", (Number)(pageSize == null ? 100 : pageSize));
        json.addProperty("status_filter", (Number)status);
        if (ArrayUtils.isNotEmpty((Object[])userIds) || ArrayUtils.isNotEmpty((Object[])partyIds)) {
            JsonObject ownerFilter = new JsonObject();
            if (ArrayUtils.isNotEmpty((Object[])userIds)) {
                json.add("userid_list", (JsonElement)new Gson().toJsonTree((Object)userIds).getAsJsonArray());
            }
            if (ArrayUtils.isNotEmpty((Object[])partyIds)) {
                json.add("partyid_list", (JsonElement)new Gson().toJsonTree((Object)partyIds).getAsJsonArray());
            }
            json.add("owner_filter", (JsonElement)ownerFilter);
        }
        String url = this.mainService.getWxCpConfigStorage().getApiUrl("/cgi-bin/externalcontact/groupchat/list");
        String result = this.mainService.post(url, json.toString());
        return WxCpUserExternalGroupChatList.fromJson(result);
    }

    @Override
    public WxCpUserExternalGroupChatInfo getGroupChat(String chatId) throws WxErrorException {
        JsonObject json = new JsonObject();
        json.addProperty("chat_id", chatId);
        String url = this.mainService.getWxCpConfigStorage().getApiUrl("/cgi-bin/externalcontact/groupchat/get");
        String result = this.mainService.post(url, json.toString());
        return WxCpUserExternalGroupChatInfo.fromJson(result);
    }

    @Override
    public WxCpUserExternalUserBehaviorStatistic getUserBehaviorStatistic(Date startTime, Date endTime, String[] userIds, String[] partyIds) throws WxErrorException {
        JsonObject json = new JsonObject();
        json.addProperty("start_time", (Number)(startTime.getTime() / 1000L));
        json.addProperty("end_time", (Number)(endTime.getTime() / 1000L));
        if (ArrayUtils.isNotEmpty((Object[])userIds) || ArrayUtils.isNotEmpty((Object[])partyIds)) {
            if (ArrayUtils.isNotEmpty((Object[])userIds)) {
                json.add("userid", (JsonElement)new Gson().toJsonTree((Object)userIds).getAsJsonArray());
            }
            if (ArrayUtils.isNotEmpty((Object[])partyIds)) {
                json.add("partyid", (JsonElement)new Gson().toJsonTree((Object)partyIds).getAsJsonArray());
            }
        }
        String url = this.mainService.getWxCpConfigStorage().getApiUrl("/cgi-bin/externalcontact/get_user_behavior_data");
        String result = this.mainService.post(url, json.toString());
        return WxCpUserExternalUserBehaviorStatistic.fromJson(result);
    }

    @Override
    public WxCpUserExternalGroupChatStatistic getGroupChatStatistic(Date startTime, Integer orderBy, Integer orderAsc, Integer pageIndex, Integer pageSize, String[] userIds, String[] partyIds) throws WxErrorException {
        JsonObject json = new JsonObject();
        json.addProperty("day_begin_time", (Number)(startTime.getTime() / 1000L));
        json.addProperty("order_by", (Number)(orderBy == null ? 1 : orderBy));
        json.addProperty("order_asc", (Number)(orderAsc == null ? 0 : orderAsc));
        json.addProperty("offset", (Number)(pageIndex == null ? 0 : pageIndex));
        json.addProperty("limit", (Number)(pageSize == null ? 500 : pageSize));
        if (ArrayUtils.isNotEmpty((Object[])userIds) || ArrayUtils.isNotEmpty((Object[])partyIds)) {
            JsonObject ownerFilter = new JsonObject();
            if (ArrayUtils.isNotEmpty((Object[])userIds)) {
                json.add("userid_list", (JsonElement)new Gson().toJsonTree((Object)userIds).getAsJsonArray());
            }
            if (ArrayUtils.isNotEmpty((Object[])partyIds)) {
                json.add("partyid_list", (JsonElement)new Gson().toJsonTree((Object)partyIds).getAsJsonArray());
            }
            json.add("owner_filter", (JsonElement)ownerFilter);
        }
        String url = this.mainService.getWxCpConfigStorage().getApiUrl("/cgi-bin/externalcontact/groupchat/statistic");
        String result = this.mainService.post(url, json.toString());
        return WxCpUserExternalGroupChatStatistic.fromJson(result);
    }

    public WxCpExternalContactServiceImpl(WxCpService mainService) {
        this.mainService = mainService;
    }
}

