/*
 * Decompiled with CFR 0.152.
 */
package me.chanjar.weixin.cp.config.impl;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import lombok.NonNull;
import me.chanjar.weixin.common.bean.WxAccessToken;
import me.chanjar.weixin.common.redis.RedissonWxRedisOps;
import me.chanjar.weixin.common.redis.WxRedisOps;
import me.chanjar.weixin.cp.config.impl.WxCpDefaultConfigImpl;
import org.apache.commons.lang3.StringUtils;
import org.redisson.api.RedissonClient;

public class WxCpRedissonConfigImpl
extends WxCpDefaultConfigImpl {
    protected static final String LOCK_KEY = "wechat_cp_lock:";
    protected static final String CP_ACCESS_TOKEN_KEY = "wechat_cp_access_token_key:";
    protected static final String CP_JSAPI_TICKET_KEY = "wechat_cp_jsapi_ticket_key:";
    protected static final String CP_AGENT_JSAPI_TICKET_KEY = "wechat_cp_agent_jsapi_ticket_key:";
    protected String keyPrefix;
    protected String accessTokenKey;
    protected String jsapiTicketKey;
    protected String agentJsapiTicketKey;
    protected String lockKey;
    private final WxRedisOps redisOps;

    public WxCpRedissonConfigImpl(@NonNull RedissonClient redissonClient, String keyPrefix) {
        this((WxRedisOps)new RedissonWxRedisOps(redissonClient), keyPrefix);
        if (redissonClient == null) {
            throw new NullPointerException("redissonClient is marked non-null but is null");
        }
    }

    public WxCpRedissonConfigImpl(@NonNull RedissonClient redissonClient) {
        this(redissonClient, null);
        if (redissonClient == null) {
            throw new NullPointerException("redissonClient is marked non-null but is null");
        }
    }

    private WxCpRedissonConfigImpl(@NonNull WxRedisOps redisOps, String keyPrefix) {
        if (redisOps == null) {
            throw new NullPointerException("redisOps is marked non-null but is null");
        }
        this.redisOps = redisOps;
        this.keyPrefix = keyPrefix;
    }

    @Override
    public void setAgentId(Integer agentId) {
        super.setAgentId(agentId);
        String ukey = this.getCorpId().concat(":").concat(String.valueOf(agentId));
        String prefix = StringUtils.isBlank((CharSequence)this.keyPrefix) ? "" : (StringUtils.endsWith((CharSequence)this.keyPrefix, (CharSequence)":") ? this.keyPrefix : this.keyPrefix + ":");
        this.lockKey = prefix + LOCK_KEY.concat(ukey);
        this.accessTokenKey = prefix + CP_ACCESS_TOKEN_KEY.concat(ukey);
        this.jsapiTicketKey = prefix + CP_JSAPI_TICKET_KEY.concat(ukey);
        this.agentJsapiTicketKey = prefix + CP_AGENT_JSAPI_TICKET_KEY.concat(ukey);
    }

    protected Lock getLockByKey(String key) {
        return this.redisOps.getLock(key);
    }

    @Override
    public Lock getAccessTokenLock() {
        return this.getLockByKey(this.lockKey.concat(":").concat("accessToken"));
    }

    @Override
    public Lock getAgentJsapiTicketLock() {
        return this.getLockByKey(this.lockKey.concat(":").concat("agentJsapiTicket"));
    }

    @Override
    public Lock getJsapiTicketLock() {
        return this.getLockByKey(this.lockKey.concat(":").concat("jsapiTicket"));
    }

    @Override
    public String getAccessToken() {
        return this.redisOps.getValue(this.accessTokenKey);
    }

    @Override
    public boolean isAccessTokenExpired() {
        Long expire = this.redisOps.getExpire(this.accessTokenKey);
        return expire == null || expire < 2L;
    }

    @Override
    public void updateAccessToken(WxAccessToken accessToken) {
        this.redisOps.setValue(this.accessTokenKey, accessToken.getAccessToken(), accessToken.getExpiresIn(), TimeUnit.SECONDS);
    }

    @Override
    public void updateAccessToken(String accessToken, int expiresInSeconds) {
        this.redisOps.setValue(this.accessTokenKey, accessToken, expiresInSeconds, TimeUnit.SECONDS);
    }

    @Override
    public void expireAccessToken() {
        this.redisOps.expire(this.accessTokenKey, 0, TimeUnit.SECONDS);
    }

    @Override
    public String getJsapiTicket() {
        return this.redisOps.getValue(this.jsapiTicketKey);
    }

    @Override
    public boolean isJsapiTicketExpired() {
        Long expire = this.redisOps.getExpire(this.jsapiTicketKey);
        return expire == null || expire < 2L;
    }

    @Override
    public void expireJsapiTicket() {
        this.redisOps.expire(this.jsapiTicketKey, 0, TimeUnit.SECONDS);
    }

    @Override
    public void updateJsapiTicket(String jsapiTicket, int expiresInSeconds) {
        this.redisOps.setValue(this.jsapiTicketKey, jsapiTicket, expiresInSeconds, TimeUnit.SECONDS);
    }

    @Override
    public void expireAgentJsapiTicket() {
        this.redisOps.expire(this.agentJsapiTicketKey, 0, TimeUnit.SECONDS);
    }

    @Override
    public void updateAgentJsapiTicket(String agentJsapiTicket, int expiresInSeconds) {
        this.redisOps.setValue(this.agentJsapiTicketKey, agentJsapiTicket, expiresInSeconds, TimeUnit.SECONDS);
    }

    @Override
    public String getAgentJsapiTicket() {
        return this.redisOps.getValue(this.agentJsapiTicketKey);
    }

    @Override
    public boolean isAgentJsapiTicketExpired() {
        Long expire = this.redisOps.getExpire(this.agentJsapiTicketKey);
        return expire == null || expire < 2L;
    }
}

