/*
 * Decompiled with CFR 0.152.
 */
package me.chanjar.weixin.cp.api.impl;

import com.google.gson.JsonObject;
import java.io.IOException;
import java.util.concurrent.locks.Lock;
import me.chanjar.weixin.common.WxType;
import me.chanjar.weixin.common.bean.WxAccessToken;
import me.chanjar.weixin.common.error.WxError;
import me.chanjar.weixin.common.error.WxErrorException;
import me.chanjar.weixin.common.util.json.GsonParser;
import me.chanjar.weixin.cp.api.impl.WxCpServiceApacheHttpClientImpl;
import org.apache.http.HttpResponse;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.BasicResponseHandler;
import org.apache.http.impl.client.CloseableHttpClient;

public class WxCpServiceImpl
extends WxCpServiceApacheHttpClientImpl {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getAccessToken(boolean forceRefresh) throws WxErrorException {
        if (!this.getWxCpConfigStorage().isAccessTokenExpired() && !forceRefresh) {
            return this.getWxCpConfigStorage().getAccessToken();
        }
        Lock lock = this.getWxCpConfigStorage().getAccessTokenLock();
        lock.lock();
        try {
            if (!this.getWxCpConfigStorage().isAccessTokenExpired() && !forceRefresh) {
                String string = this.getWxCpConfigStorage().getAccessToken();
                return string;
            }
            String url = String.format(this.getWxCpConfigStorage().getApiUrl("/cgi-bin/gettoken?corpid=%s&corpsecret=%s"), this.configStorage.getCorpId(), this.configStorage.getCorpSecret());
            try {
                String resultContent;
                HttpGet httpGet = new HttpGet(url);
                if (this.getRequestHttpProxy() != null) {
                    RequestConfig config = RequestConfig.custom().setProxy(this.getRequestHttpProxy()).build();
                    httpGet.setConfig(config);
                }
                try (CloseableHttpClient httpClient = this.getRequestHttpClient();
                     CloseableHttpResponse response = httpClient.execute((HttpUriRequest)httpGet);){
                    resultContent = new BasicResponseHandler().handleResponse((HttpResponse)response);
                }
                finally {
                    httpGet.releaseConnection();
                }
                WxError error = WxError.fromJson((String)resultContent, (WxType)WxType.CP);
                if (error.getErrorCode() != 0) {
                    throw new WxErrorException(error);
                }
                WxAccessToken accessToken = WxAccessToken.fromJson((String)resultContent);
                this.getWxCpConfigStorage().updateAccessToken(accessToken.getAccessToken(), accessToken.getExpiresIn());
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        finally {
            lock.unlock();
        }
        return this.getWxCpConfigStorage().getAccessToken();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getAgentJsapiTicket(boolean forceRefresh) throws WxErrorException {
        if (forceRefresh) {
            this.getWxCpConfigStorage().expireAgentJsapiTicket();
        }
        if (this.getWxCpConfigStorage().isAgentJsapiTicketExpired()) {
            Lock lock = this.getWxCpConfigStorage().getAgentJsapiTicketLock();
            lock.lock();
            try {
                if (this.getWxCpConfigStorage().isAgentJsapiTicketExpired()) {
                    String responseContent = this.get(this.getWxCpConfigStorage().getApiUrl("/cgi-bin/ticket/get?&type=agent_config"), null);
                    JsonObject jsonObject = GsonParser.parse((String)responseContent);
                    this.getWxCpConfigStorage().updateAgentJsapiTicket(jsonObject.get("ticket").getAsString(), jsonObject.get("expires_in").getAsInt());
                }
            }
            finally {
                lock.unlock();
            }
        }
        return this.getWxCpConfigStorage().getAgentJsapiTicket();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getJsapiTicket(boolean forceRefresh) throws WxErrorException {
        if (forceRefresh) {
            this.getWxCpConfigStorage().expireJsapiTicket();
        }
        if (this.getWxCpConfigStorage().isJsapiTicketExpired()) {
            Lock lock = this.getWxCpConfigStorage().getJsapiTicketLock();
            lock.lock();
            try {
                if (this.getWxCpConfigStorage().isJsapiTicketExpired()) {
                    String responseContent = this.get(this.getWxCpConfigStorage().getApiUrl("/cgi-bin/get_jsapi_ticket"), null);
                    JsonObject tmpJsonObject = GsonParser.parse((String)responseContent);
                    this.getWxCpConfigStorage().updateJsapiTicket(tmpJsonObject.get("ticket").getAsString(), tmpJsonObject.get("expires_in").getAsInt());
                }
            }
            finally {
                lock.unlock();
            }
        }
        return this.getWxCpConfigStorage().getJsapiTicket();
    }
}

